/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.command;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.AbstractMultiRowCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeRowsCommand;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.swt.graphics.Drawable;

public class AutoResizeRowsCommand
extends AbstractMultiRowCommand {
    private final IConfigRegistry configRegistry;
    private final GCFactory gcFactory;
    private final boolean transformPositions;

    public AutoResizeRowsCommand(InitializeAutoResizeRowsCommand initCommand) {
        super(initCommand.getSourceLayer(), initCommand.getRowPositions());
        this.configRegistry = initCommand.getConfigRegistry();
        this.gcFactory = initCommand.getGCFactory();
        this.transformPositions = true;
    }

    public AutoResizeRowsCommand(NatTable natTable, int ... rowPositions) {
        this(natTable, false, rowPositions);
    }

    public AutoResizeRowsCommand(NatTable natTable, boolean transformPositions, int ... rowPositions) {
        super(natTable, rowPositions);
        this.configRegistry = natTable.getConfigRegistry();
        this.gcFactory = new GCFactory((Drawable)natTable);
        this.transformPositions = transformPositions;
    }

    protected AutoResizeRowsCommand(AutoResizeRowsCommand command) {
        super(command);
        this.configRegistry = command.configRegistry;
        this.gcFactory = command.gcFactory;
        this.transformPositions = command.transformPositions;
    }

    @Override
    public ILayerCommand cloneCommand() {
        return new AutoResizeRowsCommand(this);
    }

    public GCFactory getGCFactory() {
        return this.gcFactory;
    }

    public IConfigRegistry getConfigRegistry() {
        return this.configRegistry;
    }

    public boolean doPositionTransformation() {
        return this.transformPositions;
    }
}

