/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TransformedLayerCell;

public class SpanningLayerCell
extends TransformedLayerCell {
    private int columnSpan;
    private int rowSpan;

    public SpanningLayerCell(ILayerCell cell, int columnSpan, int rowSpan) {
        super(cell);
        this.columnSpan = columnSpan;
        this.rowSpan = rowSpan;
    }

    @Override
    public int getColumnSpan() {
        return this.columnSpan;
    }

    @Override
    public int getRowSpan() {
        return this.rowSpan;
    }

    @Override
    public boolean isSpannedCell() {
        return this.columnSpan > 1 || this.rowSpan > 1;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.columnSpan;
        result = 31 * result + this.rowSpan;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpanningLayerCell other = (SpanningLayerCell)obj;
        if (this.columnSpan != other.columnSpan) {
            return false;
        }
        return this.rowSpan == other.rowSpan;
    }
}

