/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.indicator;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public class RowHideIndicatorEventMatcher
extends MouseEventMatcher {
    protected ILayer rowHeaderLayer;

    public RowHideIndicatorEventMatcher(int stateMask, String eventRegion, int button, ILayer rowHeaderLayer) {
        super(stateMask, eventRegion, button);
        this.rowHeaderLayer = rowHeaderLayer;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        return super.matches(natTable, event, regionLabels) && this.hasHiddenRows(natTable, event);
    }

    private boolean hasHiddenRows(ILayer natLayer, MouseEvent event) {
        NatEventData eventData;
        int rowPosition = CellEdgeDetectUtil.getRowPosition(natLayer, new Point(event.x, event.y));
        if (rowPosition < 0) {
            return false;
        }
        LabelStack customLabels = natLayer.getConfigLabelsByPosition(this.rowHeaderLayer != null ? this.rowHeaderLayer.getColumnCount() : eventData.getColumnPosition(), (eventData = NatEventData.createInstanceFromEvent(event)).getRowPosition());
        return customLabels.hasLabel("ROW_TOP_HIDDEN") || customLabels.hasLabel("ROW_BOTTOM_HIDDEN");
    }
}

