/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageFoundEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageLostEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.internal.messages.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.FragmentsOrdererHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageCreateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.papyrus.uml.diagram.stereotype.edition.editpart.AppliedStereotypesCommentLinkEditPart;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class OLDSequenceGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    private static final int MARGIN = 2;

    protected Command getConnectionAndRelationshipCreateCommand(CreateConnectionViewAndElementRequest request) {
        LifelineEditPart lifelinePart;
        Map extendedData = request.getExtendedData();
        String requestHint = request.getConnectionViewAndElementDescriptor().getSemanticHint();
        if ((this.isCreatedNearOccurrenceSpecification(requestHint) || this.isOnOccerrenceSpecification(request.getLocation())) && (lifelinePart = SequenceUtil.getParentLifelinePart((EditPart)this.getHost())) != null) {
            Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = SequenceUtil.findNearestEvent(request.getLocation(), lifelinePart);
            List<Object> events = Collections.emptyList();
            Point location = null;
            if (eventAndLocation != null) {
                location = eventAndLocation.getKey();
                events = eventAndLocation.getValue();
            }
            extendedData.put("Nearest occurrence specification", events);
            extendedData.put("Nearest occurrence specification location", location);
            if (location != null) {
                request.setLocation(location);
            }
        }
        return super.getConnectionAndRelationshipCreateCommand(request);
    }

    private boolean isOnOccerrenceSpecification(Point location) {
        EditPart editPart = this.getHost().getViewer().findObjectAt(location);
        if (editPart == null) {
            return false;
        }
        Object model = editPart.getModel();
        if (model instanceof View) {
            return ViewUtil.resolveSemanticElement((View)((View)model)) instanceof OccurrenceSpecification;
        }
        return false;
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        Command command;
        LifelineEditPart lifelinePart;
        Map extendedData = request.getExtendedData();
        String requestHint = request.getConnectionViewAndElementDescriptor().getSemanticHint();
        if ((this.isCreatedNearOccurrenceSpecification(requestHint) || this.isOnOccerrenceSpecification(request.getLocation())) && (lifelinePart = SequenceUtil.getParentLifelinePart((EditPart)this.getHost())) != null) {
            Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = SequenceUtil.findNearestEvent(request.getLocation(), lifelinePart);
            List<Object> events = Collections.emptyList();
            Point location = null;
            if (eventAndLocation != null) {
                location = eventAndLocation.getKey();
                events = eventAndLocation.getValue();
            }
            extendedData.put("Nearest occurrence specification (end)", events);
            extendedData.put("Nearest occurrence specification location (end)", location);
            if (location != null) {
                request.setLocation(location);
            }
        }
        if ((command = super.getConnectionAndRelationshipCompleteCommand(request)) != null && command.canExecute()) {
            command = command.chain(FragmentsOrdererHelper.createOrderingFragmentsCommand((EditPart)this.getHost(), request));
        }
        return command;
    }

    private boolean isCreatedNearOccurrenceSpecification(String requestHint) {
        String generalOrderingHint = ((IHintedType)UMLElementTypes.GeneralOrdering_Edge).getSemanticHint();
        return generalOrderingHint.equals(requestHint);
    }

    protected boolean isMessageHint(String requestHint) {
        ArrayList<String> messageHints = new ArrayList<String>(7);
        String messageHint = ((IHintedType)UMLElementTypes.Message_SynchEdge).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_AsynchEdge).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_ReplyEdge).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_CreateEdge).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_DeleteEdge).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_LostEdge).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_FoundEdge).getSemanticHint();
        messageHints.add(messageHint);
        return messageHints.contains(requestHint);
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        LifelineEditPart target;
        EditPart targetEditPart = request.getTargetEditPart();
        if (targetEditPart != null && targetEditPart instanceof LifelineEditPart && (target = (LifelineEditPart)targetEditPart).getPrimaryShape() != null) {
            Rectangle sourceBounds = target.getPrimaryShape().getFigureLifelineNameContainerFigure().getBounds().getCopy();
            Point sourcePointCopy = request.getLocation().getCopy();
            target.getFigure().translateToRelative((Translatable)sourcePointCopy);
            if (sourcePointCopy.y() < sourceBounds.getBottom().y()) {
                target.getFigure().translateToAbsolute((Translatable)sourceBounds);
                request.getLocation().setY(sourceBounds.getBottom().y() + 1);
            }
        }
        PointEx sourcePoint = new PointEx(request.getLocation());
        Viewport vp = this.findViewport((GraphicalEditPart)this.getHost().getViewer().getRootEditPart());
        if (vp != null) {
            Point loc1 = vp.getClientArea().getLocation().getCopy();
            sourcePoint.setViewportLocation(loc1);
        }
        request.getExtendedData().put("Location of connection source point", sourcePoint);
        request.getExtendedData().put("Source model container", SequenceUtil.findInteractionFragmentContainerAt(sourcePoint, (EditPart)this.getHost()));
        return super.getConnectionCreateCommand(request);
    }

    protected Viewport findViewport(GraphicalEditPart part) {
        IFigure figure = null;
        Viewport port = null;
        do {
            if (!((figure = figure == null ? part.getContentPane() : figure.getParent()) instanceof Viewport)) continue;
            port = (Viewport)figure;
            break;
        } while (figure != part.getFigure() && figure != null);
        return port;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Viewport vp;
        Command command = super.getConnectionCompleteCommand(request);
        if (command == null) {
            return UnexecutableCommand.INSTANCE;
        }
        String requestHint = null;
        if (request instanceof CreateConnectionViewRequest && !this.isMessageHint(requestHint = ((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint())) {
            return command;
        }
        Point sourcePoint = (Point)request.getExtendedData().get("Location of connection source point");
        Point targetPoint = request.getLocation();
        if (sourcePoint instanceof PointEx && (vp = this.findViewport((GraphicalEditPart)this.getHost().getViewer().getRootEditPart())) != null) {
            Point loc2 = vp.getClientArea().getLocation();
            sourcePoint = ((PointEx)sourcePoint).adjustToFitNewViewport(loc2);
        }
        boolean messageCreate = ((IHintedType)UMLElementTypes.Message_CreateEdge).getSemanticHint().equals(requestHint);
        if (!(sourcePoint != null && sourcePoint.y < targetPoint.y + 2 || messageCreate || this.isLostFoundMessage(requestHint))) {
            return UnexecutableCommand.INSTANCE;
        }
        if (request.getSourceEditPart().equals(request.getTargetEditPart()) && sourcePoint.y >= targetPoint.y) {
            return UnexecutableCommand.INSTANCE;
        }
        if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor desc = ((CreateConnectionViewAndElementRequest)request).getConnectionViewAndElementDescriptor();
            String replyHint = ((IHintedType)UMLElementTypes.Message_ReplyEdge).getSemanticHint();
            if (replyHint.equals(desc.getSemanticHint()) && request.getSourceEditPart() instanceof IGraphicalEditPart) {
                Rectangle srcBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)request.getSourceEditPart());
                int bottom = srcBounds.getBottom().y;
                if (bottom >= targetPoint.y + 2) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
        }
        if (messageCreate && request.getSourceEditPart() != null && request.getTargetEditPart() != null && LifelineMessageCreateHelper.hasMessageCreate((GraphicalEditPart)request.getSourceEditPart(), request.getTargetEditPart())) {
            return UnexecutableCommand.INSTANCE;
        }
        request.getExtendedData().put("Target model container", SequenceUtil.findInteractionFragmentContainerAt(targetPoint, (EditPart)this.getHost()));
        if (this.connectionFeedback != null && ((IHintedType)UMLElementTypes.Message_AsynchEdge).getSemanticHint().equals(requestHint)) {
            this.updateConnectionBendpoints(request, command);
        }
        if (request.getTargetEditPart() instanceof LifelineEditPart && !request.getSourceEditPart().equals(request.getTargetEditPart()) && requestHint.equals(((IHintedType)UMLElementTypes.Message_CreateEdge).getSemanticHint())) {
            OLDLifelineEditPart target = (OLDLifelineEditPart)request.getTargetEditPart();
            command = LifelineMessageCreateHelper.moveLifelineDown(command, target, sourcePoint.getCopy());
        }
        return command;
    }

    private void updateConnectionBendpoints(CreateConnectionRequest request, Command command) {
        boolean isSelfLink;
        if (this.connectionFeedback == null || this.connectionFeedback.getPoints().size() < 4) {
            return;
        }
        if (!(command instanceof ICommandProxy)) {
            return;
        }
        ICommand iCommand = ((ICommandProxy)command).getICommand();
        if (!(iCommand instanceof CompositeCommand)) {
            return;
        }
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP == null) {
            return;
        }
        LifelineEditPart sourceLifeline = this.getLifeline(request.getSourceEditPart());
        LifelineEditPart targetLifeline = this.getLifeline(request.getTargetEditPart());
        boolean bl = isSelfLink = sourceLifeline != null && ((Object)((Object)sourceLifeline)).equals((Object)targetLifeline);
        if (!isSelfLink) {
            return;
        }
        CompositeCommand cc = (CompositeCommand)iCommand;
        SetConnectionAnchorsCommand scaCommand = null;
        SetConnectionBendpointsCommand sbbCommand = null;
        for (Object next : cc) {
            if (next instanceof SetConnectionBendpointsCommand) {
                sbbCommand = (SetConnectionBendpointsCommand)next;
            } else if (next instanceof SetConnectionAnchorsCommand) {
                scaCommand = (SetConnectionAnchorsCommand)next;
            }
            if (sbbCommand != null && scaCommand != null) break;
        }
        if (sbbCommand == null || scaCommand == null) {
            return;
        }
        ConnectionAnchor targetAnchor = targetEP.getTargetConnectionAnchor((Request)request);
        INodeEditPart sourceEditPart = (INodeEditPart)request.getSourceEditPart();
        ConnectionAnchor sourceAnchor = sourceEditPart.mapTerminalToConnectionAnchor(scaCommand.getNewSourceTerminal());
        PointList pointList = this.connectionFeedback.getPoints().getCopy();
        this.connectionFeedback.translateToAbsolute((Translatable)pointList);
        sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
    }

    private LifelineEditPart getLifeline(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart instanceof LifelineEditPart) {
            return (LifelineEditPart)editPart;
        }
        return this.getLifeline(editPart.getParent());
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        if (request.getConnectionEditPart() instanceof MessageCreateEditPart && request.getTarget() != null && !LifelineMessageCreateHelper.canReconnectMessageCreate(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        ConnectionEditPart connection = request.getConnectionEditPart();
        if (connection instanceof AppliedStereotypesCommentLinkEditPart && connection.getSource() != this.getConnectableEditPart()) {
            return UnexecutableCommand.INSTANCE;
        }
        Command command = super.getReconnectSourceCommand(request);
        if (command != null && command.canExecute() && request.getConnectionEditPart() instanceof AbstractMessageEditPart) {
            command = command.chain(FragmentsOrdererHelper.createOrderingFragmentsCommand((EditPart)this.getHost(), request));
        }
        return command;
    }

    private boolean isLostFoundMessage(ReconnectRequest request) {
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        return connectionEditPart instanceof MessageFoundEditPart || connectionEditPart instanceof MessageLostEditPart;
    }

    private boolean isLostFoundMessage(String requestHint) {
        return ((IHintedType)UMLElementTypes.Message_LostEdge).getSemanticHint().equals(requestHint) || ((IHintedType)UMLElementTypes.Message_FoundEdge).getSemanticHint().equals(requestHint);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command command = super.getReconnectTargetCommand(request);
        if (command != null && command.canExecute() && request.getConnectionEditPart() instanceof AbstractMessageEditPart) {
            command = command.chain(FragmentsOrdererHelper.createOrderingFragmentsCommand((EditPart)this.getHost(), request));
        }
        return command;
    }

    protected boolean isUphillMessage(ReconnectRequest request) {
        Edge edge;
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart.getModel() instanceof Edge && (edge = (Edge)connectionEditPart.getModel()).getElement() instanceof Message && connectionEditPart.getFigure() instanceof Polyline) {
            Polyline polyline = (Polyline)connectionEditPart.getFigure();
            Point end = polyline.getEnd().getCopy();
            Point start = polyline.getStart().getCopy();
            polyline.getParent().translateToAbsolute((Translatable)end);
            polyline.getParent().translateToAbsolute((Translatable)start);
            if ("Reconnection source".equals(request.getType())) {
                return request.getLocation().y >= end.y + 2;
            }
            if ("Reconnection target".equals(request.getType())) {
                return start.y >= request.getLocation().y + 2;
            }
            return start.y >= end.y + 2;
        }
        return false;
    }

    protected Connection createDummyConnection(Request req) {
        Connection conn = super.createDummyConnection(req);
        conn.setForegroundColor(ColorConstants.black);
        return conn;
    }

    protected ICommand getPromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
        return new SequencePromptAndCreateConnectionCommand(content, request);
    }

    public EditPart getTargetEditPart(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType()) || "Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            GraphicalEditPart host = this.getHost();
            if (request instanceof CreateConnectionRequest) {
                if (host instanceof InteractionEditPart) {
                    if ("connection end".equals(request.getType()) && this.isCreateConnectionRequest(request, UMLElementTypes.Message_LostEdge)) {
                        return host;
                    }
                    if ("connection start".equals(request.getType()) && this.isCreateConnectionRequest(request, UMLElementTypes.Message_FoundEdge)) {
                        return host;
                    }
                    InteractionEditPart interactionPart = (InteractionEditPart)host;
                    if (!this.touchesInteractionBounds((GraphicalEditPart)interactionPart, ((CreateConnectionRequest)request).getLocation())) {
                        return null;
                    }
                } else {
                    CreateConnectionRequest req;
                    Point location;
                    if (host instanceof InteractionOperandEditPart) {
                        return null;
                    }
                    if (host instanceof InteractionFragmentEditPart && !this.touchesInteractionBounds(host, location = (req = (CreateConnectionRequest)request).getLocation().getCopy())) {
                        return null;
                    }
                }
            } else if (request instanceof ReconnectRequest) {
                if (host instanceof InteractionEditPart) {
                    InteractionEditPart interactionEditPart;
                    ConnectionEditPart conn = ((ReconnectRequest)request).getConnectionEditPart();
                    Object model = conn.getModel();
                    if (model instanceof View) {
                        if ("Reconnection target".equals(request.getType()) && UMLVisualIDRegistry.getVisualID((View)model).equals("Message_LostEdge")) {
                            return host;
                        }
                        if ("Reconnection source".equals(request.getType()) && UMLVisualIDRegistry.getVisualID((View)model).equals("Message_FoundEdge")) {
                            return host;
                        }
                    }
                    if (!this.touchesInteractionBounds((GraphicalEditPart)(interactionEditPart = (InteractionEditPart)this.getHost()), ((ReconnectRequest)request).getLocation())) {
                        return null;
                    }
                } else {
                    Point location;
                    if (host instanceof InteractionOperandEditPart) {
                        return null;
                    }
                    if (host instanceof InteractionFragmentEditPart && !this.touchesInteractionBounds(host, location = ((ReconnectRequest)request).getLocation().getCopy())) {
                        return null;
                    }
                }
            }
            return host;
        }
        return null;
    }

    private boolean touchesInteractionBounds(GraphicalEditPart interaction, Point location) {
        Point p = location.getCopy();
        IFigure figure = interaction.getFigure();
        figure.translateToRelative((Translatable)p);
        Rectangle r = figure.getBounds().getCopy();
        Rectangle innerRetangle = r.getShrinked(20, 20);
        if (innerRetangle.contains(p)) {
            return false;
        }
        return r.getExpanded(1, 1).contains(p);
    }

    protected boolean isCreateConnectionRequest(Request request, IElementType type) {
        if (request instanceof CreateConnectionViewRequest) {
            String requestHint = ((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint();
            if (((IHintedType)type).getSemanticHint().equals(requestHint)) {
                return true;
            }
        }
        return false;
    }

    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest req) {
        if (req.getSourceEditPart() instanceof InteractionEditPart || req.getSourceEditPart() instanceof CombinedFragmentEditPart) {
            return ConnectionRouter.NULL;
        }
        return super.getDummyConnectionRouter(req);
    }

    private static class PointEx
    extends Point {
        private static final long serialVersionUID = -3049675238350676816L;
        private Point viewportLocation;

        public PointEx(Point pt) {
            super(pt);
        }

        public void setViewportLocation(Point p) {
            if (p != null) {
                this.viewportLocation = p.getCopy();
            }
        }

        public Point adjustToFitNewViewport(Point newViewportLoc) {
            Point pt = this.getCopy();
            if (newViewportLoc != null && this.viewportLocation != null && !newViewportLoc.equals((Object)this.viewportLocation)) {
                pt.x += this.viewportLocation.x - newViewportLoc.x;
                pt.y += this.viewportLocation.y - newViewportLoc.y;
            }
            return pt;
        }
    }

    protected class SequencePromptAndCreateConnectionCommand
    extends GraphicalNodeEditPolicy.PromptAndCreateConnectionCommand {
        public SequencePromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
            super((GraphicalNodeEditPolicy)OLDSequenceGraphicalNodeEditPolicy.this, content, request);
        }

        protected ILabelProvider getLabelProvider() {
            return new CreateOrSelectElementCommand.LabelProvider(){

                public String getText(Object object) {
                    block25: {
                        if (!(object instanceof IHintedType)) break block25;
                        IHintedType elementType = (IHintedType)object;
                        switch (UMLVisualIDRegistry.getVisualID(elementType.getSemanticHint())) {
                            case "Message_SynchEdge": {
                                return Messages.MessageSync1CreationTool_title;
                            }
                            case "Message_AsynchEdge": {
                                return Messages.MessageAsync2CreationTool_title;
                            }
                            case "Message_ReplyEdge": {
                                return Messages.MessageReply3CreationTool_title;
                            }
                            case "Message_CreateEdge": {
                                return Messages.MessageCreate4CreationTool_title;
                            }
                            case "Message_DeleteEdge": {
                                return Messages.MessageDelete5CreationTool_title;
                            }
                            case "Message_LostEdge": {
                                return Messages.MessageLost6CreationTool_title;
                            }
                            case "Message_FoundEdge": {
                                return Messages.MessageFound7CreationTool_title;
                            }
                        }
                    }
                    return super.getText(object);
                }
            };
        }
    }
}

