/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.commands.wrappers.CommandProxyWithResult;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.uml.diagram.common.commands.DeferredCreateCommand;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateLocatedConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.OLDCreateGateViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeAndLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CoordinateReferentialUtils;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeObservation;

public class CustomDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public static final String LIFELINE_MISSING = "There is no representation of lifeline {0}";
    public static final String DIALOG_TITLE = "Element missing";

    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)SequenceLinkMappingHelper.getInstance());
    }

    protected Set<String> getDroppableElementVisualId() {
        HashSet<String> elementsVisualId = new HashSet<String>();
        elementsVisualId.add("Lifeline_Shape");
        elementsVisualId.add("CombinedFragment_SubfragmentCompartment");
        elementsVisualId.add("ActionExecutionSpecification_Shape");
        elementsVisualId.add("BehaviorExecutionSpecification_Shape");
        elementsVisualId.add("InteractionUse_Shape");
        elementsVisualId.add("Interaction_Shape");
        elementsVisualId.add("InteractionOperand_Shape");
        elementsVisualId.add("CombinedFragment_Shape");
        elementsVisualId.add("Comment_AnnotatedElementEdge");
        elementsVisualId.add("ConsiderIgnoreFragment_Shape");
        elementsVisualId.add("Continuation_Shape");
        elementsVisualId.add("StateInvariant_Shape");
        elementsVisualId.add("Comment_Shape");
        elementsVisualId.add("Comment_BodyLabel");
        elementsVisualId.add("Constraint_Shape");
        elementsVisualId.add("Constraint_BodyLabel");
        elementsVisualId.add("Constraint_ConstrainedElementEdge");
        elementsVisualId.add("Package_SequenceDiagram");
        elementsVisualId.add("Message_SynchEdge");
        elementsVisualId.add("Message_AsynchEdge");
        elementsVisualId.add("Message_ReplyEdge");
        elementsVisualId.add("Message_CreateEdge");
        elementsVisualId.add("Message_CreateEdge");
        elementsVisualId.add("Message_DeleteEdge");
        elementsVisualId.add("Message_LostEdge");
        elementsVisualId.add("Message_FoundEdge");
        elementsVisualId.add("Message_LostEdge");
        elementsVisualId.add("GeneralOrdering_Edge");
        elementsVisualId.add("DestructionOccurrenceSpecification_Shape");
        elementsVisualId.add("StateInvariant_Shape");
        elementsVisualId.add("Lifeline_Shape");
        return elementsVisualId;
    }

    protected IUndoableOperation getDropObjectCommand(DropObjectsRequest dropRequest, EObject droppedObject) {
        IUndoableOperation dropObjectCommand = super.getDropObjectCommand(dropRequest, droppedObject);
        if (dropObjectCommand != null && dropObjectCommand.canExecute()) {
            return dropObjectCommand;
        }
        if (droppedObject instanceof ConnectableElement) {
            return this.doDropConnectableElement(dropRequest, (ConnectableElement)droppedObject);
        }
        return dropObjectCommand;
    }

    private IUndoableOperation doDropConnectableElement(DropObjectsRequest dropRequest, ConnectableElement droppedObject) {
        Point location = dropRequest.getLocation();
        CreateViewRequest createShapeRequest = CreateViewRequestFactory.getCreateShapeRequest((IElementType)UMLElementTypes.Lifeline_Shape, (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        createShapeRequest.setLocation(location);
        CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)createShapeRequest.getViewDescriptors().get(0);
        CreateElementRequestAdapter elementAdapter = (CreateElementRequestAdapter)viewDescriptor.getElementAdapter();
        CreateElementRequest createElementRequest = (CreateElementRequest)elementAdapter.getAdapter(CreateElementRequest.class);
        createElementRequest.setParameter("Connectable Element", (Object)droppedObject);
        GraphicalEditPart host = this.getHost();
        Command theRealCmd = ((IGraphicalEditPart)host).getCommand((Request)createShapeRequest);
        if (theRealCmd != null && theRealCmd.canExecute()) {
            return new CommandProxy(theRealCmd);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public IElementType getUMLElementType(String elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public String getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public String getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        block64: {
            block62: {
                Point location = dropRequest.getLocation().getCopy();
                if (semanticElement instanceof Gate) {
                    return this.dropGate((Gate)semanticElement, location);
                }
                if (semanticElement instanceof DurationObservation) {
                    return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)semanticElement, dropRequest));
                }
                if (nodeVISUALID == null) break block62;
                switch (nodeVISUALID) {
                    case "CombinedFragment_SubfragmentCompartment": 
                    case "ActionExecutionSpecification_Shape": 
                    case "BehaviorExecutionSpecification_Shape": {
                        return this.dropExecutionSpecification((ExecutionSpecification)semanticElement, nodeVISUALID, location);
                    }
                    case "DestructionOccurrenceSpecification_Shape": {
                        return this.dropDestructionOccurrence((DestructionOccurrenceSpecification)semanticElement, nodeVISUALID, location);
                    }
                    case "StateInvariant_Shape": {
                        return this.dropStateInvariant((StateInvariant)semanticElement, nodeVISUALID, location);
                    }
                    case "Constraint_Shape": 
                    case "Lifeline_Shape": 
                    case "Comment_Shape": 
                    case "Constraint_BodyLabel": 
                    case "InteractionUse_Shape": {
                        return this.dropNodeElement(semanticElement, nodeVISUALID, location);
                    }
                    case "ConsiderIgnoreFragment_Shape": 
                    case "CombinedFragment_Shape": {
                        return this.dropCombinedFragment((CombinedFragment)semanticElement, nodeVISUALID, location);
                    }
                    case "Continuation_Shape": 
                    case "InteractionOperand_Shape": {
                        return this.dropCompartmentNodeElement(semanticElement, nodeVISUALID, location);
                    }
                }
            }
            if (linkVISUALID == null) break block64;
            switch (linkVISUALID) {
                case "Message_SynchEdge": 
                case "Message_AsynchEdge": 
                case "Message_LostEdge": 
                case "Message_CreateEdge": 
                case "Message_ReplyEdge": 
                case "Message_DeleteEdge": 
                case "Message_FoundEdge": {
                    return this.dropMessage(dropRequest, semanticElement, linkVISUALID);
                }
                case "GeneralOrdering_Edge": {
                    return this.dropGeneralOrdering(dropRequest, semanticElement, linkVISUALID);
                }
            }
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropNodeElement(Element element, String nodeVISUALID, Point location) {
        List existingViews;
        if ("Lifeline_Shape" == nodeVISUALID) {
            Point diagramAbsoluteLocation = CoordinateReferentialUtils.transformPointFromScreenToDiagramReferential(location, (GraphicalViewer)this.getViewer());
            Point relativeFigurePosition = CoordinateReferentialUtils.getFigurePositionRelativeToDiagramReferential(this.getHostFigure(), DiagramUtils.getDiagramEditPartFrom((EditPart)this.getHost()));
            diagramAbsoluteLocation.translate(relativeFigurePosition.getNegated());
            Point contentPaneRelativeLocation = CoordinateReferentialUtils.getFigurePositionRelativeToDiagramReferential(((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.getHost()).getContentPane().getParent(), DiagramUtils.getDiagramEditPartFrom((EditPart)this.getHost()));
            location.setY(10 + contentPaneRelativeLocation.y);
            diagramAbsoluteLocation.translate(relativeFigurePosition);
            location = CoordinateReferentialUtils.transformPointFromDiagramToScreenReferential(location, (GraphicalViewer)this.getViewer());
        }
        Element parent = element.getOwner();
        if (this.getHostObject().equals(parent) && !(existingViews = DiagramEditPartsUtil.findViews((EObject)parent, (EditPartViewer)this.getViewer())).isEmpty()) {
            return new ICommandProxy(this.getDefaultDropNodeCommand((EditPart)this.getHost(), nodeVISUALID, location, (EObject)element));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropCombinedFragment(CombinedFragment combinedFragment, String nodeVISUALID, Point location) {
        GraphicalEditPart parentEditPart;
        List existingViews;
        Element parent = combinedFragment.getOwner();
        Element parentContainer = parent.getOwner();
        if (!(parentContainer instanceof CombinedFragment)) {
            parentContainer = parent;
        }
        if (this.getHostObject().equals(parentContainer) && !(existingViews = DiagramEditPartsUtil.findViews((EObject)parent, (EditPartViewer)this.getViewer())).isEmpty() && (parentEditPart = this.getHost()) instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart) {
            Rectangle bounds = null;
            for (Lifeline lifeline : combinedFragment.getCovereds()) {
                EditPart lifelineEditPart = this.lookForEditPart((EObject)lifeline);
                if (lifelineEditPart == null) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageDialog.openError((Shell)shell, (String)DIALOG_TITLE, (String)NLS.bind((String)LIFELINE_MISSING, (Object)lifeline.getName()));
                    return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
                }
                if (!(lifelineEditPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)) continue;
                org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart graphicalEditPart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)lifelineEditPart;
                Rectangle rectangle = graphicalEditPart.getFigure().getBounds().getCopy();
                graphicalEditPart.getFigure().translateToAbsolute((Translatable)rectangle);
                bounds = bounds == null ? rectangle : bounds.union(rectangle);
            }
            if (bounds == null) {
                return new ICommandProxy(this.getDefaultDropNodeCommand((EditPart)parentEditPart, nodeVISUALID, location, (EObject)combinedFragment));
            }
            location.x = bounds.x;
            return new ICommandProxy(this.dropCombinedFragment((EditPart)this.getHost(), nodeVISUALID, location, new Dimension(bounds.width, 100), (EObject)combinedFragment));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected ICommand dropCombinedFragment(EditPart hostEP, String nodeVISUALID, Point absoluteLocation, Dimension size, EObject droppedObject) {
        List existingViews;
        IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
        String semanticHint = null;
        if (type != null) {
            semanticHint = type.getSemanticHint();
        }
        if ((existingViews = DiagramEditPartsUtil.findViews((EObject)droppedObject, (EditPartViewer)this.getViewer())).isEmpty()) {
            EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, true, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            createViewRequest.setLocation(absoluteLocation);
            createViewRequest.setSize(size);
            Command command = hostEP.getCommand((Request)createViewRequest);
            if (createViewRequest.getNewObject() instanceof List) {
                for (Object object : (List)createViewRequest.getNewObject()) {
                    if (!(object instanceof IAdaptable)) continue;
                    DeferredCreateCommand createCommand2 = new DeferredCreateCommand(this.getEditingDomain(), droppedObject, (IAdaptable)object, this.getHost().getViewer());
                    command.chain((Command)new ICommandProxy((ICommand)createCommand2));
                }
            }
            return new CommandProxyWithResult(command, (Object)descriptor);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropCompartmentNodeElement(Element element, String nodeVISUALID, Point location) {
        EditPart parentEditPart;
        List existingViews;
        Element parent;
        IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
        String semanticHint = null;
        if (type != null) {
            semanticHint = type.getSemanticHint();
        }
        Element directParent = parent = element.getOwner();
        if (parent instanceof InteractionOperand) {
            parent = parent.getOwner();
        }
        if (this.getHostObject().equals(parent) && !(existingViews = DiagramEditPartsUtil.findViews((EObject)directParent, (EditPartViewer)this.getViewer())).isEmpty() && (parentEditPart = this.lookForEditPart((EObject)directParent)) != null) {
            location.setY(0);
            location.setX(0);
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)element);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, true, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            createViewRequest.setLocation(location);
            Command command = this.getHost().getCommand((Request)createViewRequest);
            return new ICommandProxy((ICommand)new CommandProxyWithResult(command, (Object)descriptor));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropTimeObservationInLifeline(TimeObservation observation, String nodeVISUALID, Point dropLocation) {
        Point middlePoint;
        NamedElement occ1;
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)observation);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
        cc.add(this.getHost().getCommand((Request)new CreateViewRequest(descriptor)));
        LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart((EditPart)this.getHost());
        if (lifelinePart != null && (occ1 = observation.getEvent()) instanceof OccurrenceSpecification && (middlePoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ1))) != null) {
            int height = this.getDefaultDropHeight(nodeVISUALID);
            Point startPoint = middlePoint.getCopy();
            if (height > 0) {
                startPoint.translate(0, -height / 2);
            }
            Rectangle newBounds = new Rectangle(startPoint, new Dimension(-1, height));
            lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
            Point parentLoc = lifelinePart.getLocation();
            newBounds.translate(parentLoc.getNegated());
            SetResizeAndLocationCommand setBoundsCommand = new SetResizeAndLocationCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
            cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            return cc;
        }
        if (this.getHost() instanceof InteractionInteractionCompartmentEditPart) {
            Rectangle newBounds = new Rectangle(dropLocation, new Dimension(-1, -1));
            ((InteractionInteractionCompartmentEditPart)this.getHost()).getFigure().translateToRelative((Translatable)newBounds);
            SetResizeAndLocationCommand setBoundsCommand = new SetResizeAndLocationCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
            cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            return cc;
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private int getDefaultDropHeight(String nodeVISUALID) {
        return -1;
    }

    private Command dropStateInvariant(StateInvariant stateInvariant, String nodeVISUALID, Point location) {
        Lifeline lifeline = (Lifeline)stateInvariant.getCovereds().get(0);
        if (lifeline.equals(this.getHostObject())) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)stateInvariant));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private List<Lifeline> getLifelines(List<View> existingViews) {
        ArrayList<Lifeline> lifelines = new ArrayList<Lifeline>();
        for (View view : existingViews) {
            EObject eObject = ViewUtil.resolveSemanticElement((View)((View)view.eContainer()));
            if (!(eObject instanceof Lifeline)) continue;
            lifelines.add((Lifeline)eObject);
        }
        return lifelines;
    }

    private Command dropGate(Gate gate, Point location) {
        return new ICommandProxy(this.getDropGateCommand(gate, location));
    }

    private ICommand getDropGateCommand(Gate gate, Point location) {
        GraphicalEditPart parent;
        EObject owner;
        List existingViews = DiagramEditPartsUtil.findViews((EObject)gate, (EditPartViewer)this.getViewer());
        if (existingViews.isEmpty() && (owner = gate.eContainer()) != null && (parent = (GraphicalEditPart)this.lookForEditPart(owner)) != null) {
            Point gateLocation = GateHelper.computeGateLocation(location, parent.getFigure(), null);
            return new OLDCreateGateViewCommand(this.getEditingDomain(), (IAdaptable)parent, gateLocation, (IAdaptable)new EObjectAdapter((EObject)gate));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropDestructionOccurrence(DestructionOccurrenceSpecification destructionOccurence, String nodeVISUALID, Point location) {
        List existingViews = DiagramEditPartsUtil.findViews((EObject)destructionOccurence, (EditPartViewer)this.getViewer());
        List<Lifeline> lifelines = this.getLifelines(existingViews);
        return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)destructionOccurence));
    }

    private Command dropExecutionSpecification(ExecutionSpecification es, String nodeVISUALID, Point location) {
        Lifeline lifeline;
        List existingViews = DiagramEditPartsUtil.findViews((EObject)es, (EditPartViewer)this.getViewer());
        if (existingViews.isEmpty() && es.getStart() != null && !es.getStart().getCovereds().isEmpty() && (lifeline = (Lifeline)es.getStart().getCovereds().get(0)).equals(this.getHostObject())) {
            IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
            String semanticHint = null;
            if (type != null) {
                semanticHint = type.getSemanticHint();
            }
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)es);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, true, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            Rectangle bounds = new Rectangle();
            Rectangle lifelineBounds = SequenceUtil.findPossibleLocationsForEvent((LifelineEditPart)this.getHost(), es.getStart());
            int xLocation = lifelineBounds.getTop().x() - AbstractExecutionSpecificationEditPart.DEFAUT_WIDTH / 2;
            bounds.setLocation(xLocation, location.y());
            bounds.setSize(AbstractExecutionSpecificationEditPart.DEFAUT_WIDTH, AbstractExecutionSpecificationEditPart.DEFAUT_HEIGHT);
            if (bounds != null) {
                createViewRequest.setLocation(bounds.getLocation());
                createViewRequest.setSize(bounds.getSize());
            }
            Command command = this.getHost().getCommand((Request)createViewRequest);
            return new ICommandProxy((ICommand)new CommandProxyWithResult(command, (Object)descriptor));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropMessage(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        List existingViews = DiagramEditPartsUtil.findViews((EObject)semanticLink, (EditPartViewer)this.getViewer());
        if (!existingViews.isEmpty()) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        Collection<?> sources = SequenceLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = SequenceLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (!sources.isEmpty() && !targets.isEmpty()) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return this.getDropLocatedLinkCommand(dropRequest, source, target, linkVISUALID, semanticLink);
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected Command getDropLocatedLinkCommand(DropObjectsRequest dropRequest, Element source, Element target, String linkVISUALID, Element semanticLink) {
        ICommand createCommand;
        org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart sourceEditPart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.lookForEditPart((EObject)source);
        org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart targetEditPart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.lookForEditPart((EObject)target);
        CompositeCommand cc = new CompositeCommand("Drop");
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getUMLElementType(linkVISUALID), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        if (sourceEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkSourceDropLocation(dropRequest.getLocation(), source, target), (EObject)source);
            cc.add((IUndoableOperation)createCommand);
            sourceAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (targetEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkTargetDropLocation(dropRequest.getLocation(), source, target), (EObject)target);
            cc.add((IUndoableOperation)createCommand);
            targetAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
        }
        CreateLocatedConnectionViewCommand aLinkCommand = new CreateLocatedConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        Point[] sourceAndTarget = this.getLinkSourceAndTargetLocations(semanticLink, sourceEditPart, targetEditPart, dropRequest.getLocation().getCopy());
        aLinkCommand.setLocations(sourceAndTarget[0], sourceAndTarget[1]);
        cc.compose((IUndoableOperation)aLinkCommand);
        return new ICommandProxy((ICommand)cc);
    }

    protected ICommand getDefaultDropNodeCommand(Point absoluteLocation, EObject droppedObject) {
        if (droppedObject instanceof Gate) {
            return this.getDropGateCommand((Gate)droppedObject, absoluteLocation);
        }
        return super.getDefaultDropNodeCommand(absoluteLocation, droppedObject);
    }

    private Point[] getLinkSourceAndTargetLocations(Element semanticLink, org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart sourceEditPart, org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart targetEditPart, Point dropLocation) {
        MessageEnd rcvEvent;
        MessageEnd sendEvent;
        Point[] sourceAndTarget = new Point[2];
        OccurrenceSpecification sourceEvent = null;
        OccurrenceSpecification targetEvent = null;
        if (semanticLink instanceof Message) {
            sendEvent = ((Message)semanticLink).getSendEvent();
            if (sendEvent instanceof OccurrenceSpecification) {
                sourceEvent = (OccurrenceSpecification)sendEvent;
            } else if (sendEvent instanceof Gate) {
                sourceAndTarget[0] = sourceEditPart != null ? SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)sourceEditPart).getCenter() : dropLocation;
            } else if (sendEvent == null) {
                sourceAndTarget[0] = dropLocation;
            }
            rcvEvent = ((Message)semanticLink).getReceiveEvent();
            if (rcvEvent instanceof OccurrenceSpecification) {
                targetEvent = (OccurrenceSpecification)rcvEvent;
            } else if (rcvEvent instanceof Gate) {
                sourceAndTarget[1] = targetEditPart != null ? SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)targetEditPart).getCenter() : dropLocation;
            } else if (rcvEvent == null) {
                sourceAndTarget[1] = dropLocation;
            }
        } else if (semanticLink instanceof GeneralOrdering) {
            sourceEvent = ((GeneralOrdering)semanticLink).getBefore();
            targetEvent = ((GeneralOrdering)semanticLink).getAfter();
        }
        if (sourceEvent != null || targetEvent != null) {
            int bottomTarget;
            int centerTarget;
            Rectangle possibleSourceLocations = null;
            Rectangle possibleTargetLocations = null;
            if (sourceEvent != null && sourceEditPart instanceof LifelineEditPart) {
                sourceAndTarget[0] = SequenceUtil.findLocationOfEvent((LifelineEditPart)sourceEditPart, (InteractionFragment)sourceEvent);
                if (sourceAndTarget[0] == null) {
                    possibleSourceLocations = SequenceUtil.findPossibleLocationsForEvent((LifelineEditPart)sourceEditPart, sourceEvent);
                }
            }
            if (targetEvent != null && targetEditPart instanceof LifelineEditPart) {
                sourceAndTarget[1] = SequenceUtil.findLocationOfEvent((LifelineEditPart)targetEditPart, (InteractionFragment)targetEvent);
                if (sourceAndTarget[1] == null) {
                    possibleTargetLocations = SequenceUtil.findPossibleLocationsForEvent((LifelineEditPart)targetEditPart, targetEvent);
                }
            }
            if (sourceAndTarget[0] == null && possibleSourceLocations != null) {
                if (sourceAndTarget[1] == null && possibleTargetLocations == null) {
                    sourceAndTarget[0] = possibleSourceLocations.getCenter();
                } else if (sourceAndTarget[1] != null) {
                    int topSource = possibleSourceLocations.y;
                    int centerSource = possibleSourceLocations.getCenter().y;
                    if (sourceAndTarget[1].y < topSource) {
                        sourceAndTarget[0] = possibleSourceLocations.getTop();
                    } else if (centerSource <= sourceAndTarget[1].y) {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                    } else {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[0].y = sourceAndTarget[1].y;
                    }
                } else {
                    centerTarget = possibleTargetLocations.getCenter().y;
                    bottomTarget = possibleTargetLocations.bottom();
                    int topSource = possibleSourceLocations.y;
                    int centerSource = possibleSourceLocations.getCenter().y;
                    if (bottomTarget < topSource) {
                        sourceAndTarget[0] = possibleSourceLocations.getTop();
                        sourceAndTarget[1] = possibleTargetLocations.getBottom();
                    } else if (centerSource <= centerTarget) {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[1] = possibleTargetLocations.getCenter();
                    } else {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[0].y = (topSource + bottomTarget) / 2;
                        sourceAndTarget[1] = possibleTargetLocations.getCenter();
                        sourceAndTarget[1].y = (topSource + bottomTarget) / 2;
                    }
                }
            }
            if (sourceAndTarget[1] == null && possibleTargetLocations != null) {
                centerTarget = possibleTargetLocations.getCenter().y;
                bottomTarget = possibleTargetLocations.bottom();
                if (sourceAndTarget[0] == null) {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                } else if (bottomTarget < sourceAndTarget[0].y) {
                    sourceAndTarget[1] = possibleTargetLocations.getBottom();
                } else if (sourceAndTarget[0].y <= centerTarget) {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                } else {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                    sourceAndTarget[1].y = sourceAndTarget[0].y;
                }
            }
        }
        if (semanticLink instanceof Message) {
            sendEvent = ((Message)semanticLink).getSendEvent();
            if (sendEvent == null && sourceAndTarget[1] != null) {
                sourceAndTarget[0] = new Point(dropLocation.x, sourceAndTarget[1].y);
            }
            if ((rcvEvent = ((Message)semanticLink).getReceiveEvent()) == null && sourceAndTarget[0] != null) {
                sourceAndTarget[1] = new Point(dropLocation.x, sourceAndTarget[0].y);
            }
        }
        return sourceAndTarget;
    }

    private Command dropGeneralOrdering(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> sources = SequenceLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = SequenceLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (!sources.isEmpty() && !targets.isEmpty()) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return this.getDropLocatedLinkCommand(dropRequest, source, target, linkVISUALID, semanticLink);
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }
}

