/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.command.AnnotatedLinkEditCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AnnotatedLinkEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.EllipseDecoration;

public class AnnotatedLinkEndEditPolicy
extends org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy {
    public static final String ANNOTATED_LINK_END_ROLE = "Annotated Link End Edit Policy";
    public static final String REQ_ANNOTATED_LINK_END = "annotated link end";
    public static final String REQ_ANNOTATED_LINK_REORIENT_END = "annotated link reorient end";

    public EditPart getTargetEditPart(Request request) {
        if (REQ_ANNOTATED_LINK_END.equals(request.getType()) || REQ_ANNOTATED_LINK_REORIENT_END.equals(request.getType())) {
            Point location = ((DropRequest)request).getLocation();
            GraphicalEditPart host = this.getHost();
            if (this.isEnterAnchorArea((EditPart)host, location)) {
                return host;
            }
        }
        return null;
    }

    private boolean isEnterAnchorArea(EditPart editPart, Point location) {
        Point p = location.getCopy();
        if (editPart instanceof InteractionEditPart || editPart instanceof CombinedFragmentEditPart || editPart instanceof InteractionOperandEditPart) {
            IFigure figure = ((AbstractGraphicalEditPart)editPart).getFigure();
            figure.translateToRelative((Translatable)p);
            Rectangle innerRetangle = figure.getBounds().getCopy().shrink(10, 10);
            if (innerRetangle.contains(p)) {
                return false;
            }
        }
        return true;
    }

    public Command getCommand(Request request) {
        if (REQ_ANNOTATED_LINK_END.equals(request.getType())) {
            return this.getConnectionCompleteCommand((CreateConnectionRequest)request);
        }
        if (REQ_ANNOTATED_LINK_REORIENT_END.equals(request.getType())) {
            return this.getReconnectTargetCommand((ReconnectRequest)request);
        }
        return null;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        ICommandProxy c = (ICommandProxy)super.getReconnectTargetCommand(request);
        if (c == null) {
            return null;
        }
        if (request.getConnectionEditPart() instanceof AnnotatedLinkEditPart) {
            CompositeCommand cc = (CompositeCommand)c.getICommand();
            AnnotatedLinkEditCommand ac = new AnnotatedLinkEditCommand(this.getEditingDomain());
            ac.setAnnotatedLink((AnnotatedLinkEditPart)request.getConnectionEditPart());
            ac.setTarget((EditPart)this.getHost());
            cc.add((IUndoableOperation)ac);
            return c;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        ICommandProxy proxy = (ICommandProxy)super.getConnectionCompleteCommand(request);
        if (proxy == null) {
            return null;
        }
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        Iterator it = cc.iterator();
        AnnotatedLinkEditCommand command = null;
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof AnnotatedLinkEditCommand)) continue;
            command = (AnnotatedLinkEditCommand)((Object)next);
            break;
        }
        if (command == null) {
            return UnexecutableCommand.INSTANCE;
        }
        command.setTarget((EditPart)this.getHost());
        return proxy;
    }

    public void eraseTargetFeedback(Request request) {
        CreateConnectionRequest connReq;
        EditPart sourceEditPart;
        EditPolicy editPolicy;
        PolylineConnection connectionFeedback;
        if (REQ_ANNOTATED_LINK_END.equals(request.getType()) && (connectionFeedback = (PolylineConnection)this.getConnectionFeedback(editPolicy = (sourceEditPart = (connReq = (CreateConnectionRequest)request).getSourceEditPart()).getEditPolicy((Object)"Annotated Link Start Edit Policy"))) != null) {
            connectionFeedback.setTargetDecoration(null);
        }
    }

    public void showSourceFeedback(Request request) {
    }

    public void eraseSourceFeedback(Request request) {
    }

    public void showTargetFeedback(Request request) {
        if (REQ_ANNOTATED_LINK_END.equals(request.getType())) {
            CreateConnectionRequest connReq = (CreateConnectionRequest)request;
            EditPart sourceEditPart = connReq.getSourceEditPart();
            EditPolicy editPolicy = sourceEditPart.getEditPolicy((Object)"Annotated Link Start Edit Policy");
            editPolicy.showSourceFeedback(request);
            PolylineConnection connectionFeedback = (PolylineConnection)this.getConnectionFeedback(editPolicy);
            if (connectionFeedback != null) {
                Command command = this.getHost().getCommand(request);
                if (command != null && command.canExecute()) {
                    EllipseDecoration dec = new EllipseDecoration();
                    dec.setPreferredSize(10, 10);
                    dec.setSize(10, 10);
                    dec.setLineWidth(2);
                    dec.setAntialias(1);
                    connectionFeedback.setTargetDecoration((RotatableDecoration)dec);
                } else {
                    connectionFeedback.setTargetDecoration(null);
                }
            }
        }
    }

    private Connection getConnectionFeedback(EditPolicy policy) {
        if (policy != null) {
            try {
                Field f = GraphicalNodeEditPolicy.class.getDeclaredField("connectionFeedback");
                f.setAccessible(true);
                return (Connection)f.get(policy);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

