/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture.representation.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.architecture.representation.ModelRule;
import org.eclipse.papyrus.infra.architecture.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.architecture.representation.impl.RuleImpl;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.DisplayUnit;

public class ModelRuleImpl
extends RuleImpl
implements ModelRule {
    protected EList<ConstraintDescriptor> constraints;
    protected static final int ELEMENT_MULTIPLICITY_EDEFAULT = 1;
    protected int elementMultiplicity = 1;
    protected EClass element;
    protected EList<EClass> stereotypes;
    protected static final int MULTIPLICITY_EDEFAULT = -1;
    protected int multiplicity = -1;

    protected ModelRuleImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return RepresentationPackage.Literals.MODEL_RULE;
    }

    public EList<ConstraintDescriptor> getConstraints() {
        if (this.constraints == null) {
            this.constraints = new EObjectContainmentWithInverseEList(ConstraintDescriptor.class, (InternalEObject)this, 1, 3);
        }
        return this.constraints;
    }

    public int getElementMultiplicity() {
        return this.elementMultiplicity;
    }

    public void setElementMultiplicity(int newElementMultiplicity) {
        int oldElementMultiplicity = this.elementMultiplicity;
        this.elementMultiplicity = newElementMultiplicity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldElementMultiplicity, this.elementMultiplicity));
        }
    }

    @Override
    public EClass getElement() {
        if (this.element != null && this.element.eIsProxy()) {
            InternalEObject oldElement = (InternalEObject)this.element;
            this.element = (EClass)this.eResolveProxy(oldElement);
            if (this.element != oldElement && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldElement, (Object)this.element));
            }
        }
        return this.element;
    }

    public EClass basicGetElement() {
        return this.element;
    }

    @Override
    public void setElement(EClass newElement) {
        EClass oldElement = this.element;
        this.element = newElement;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldElement, (Object)this.element));
        }
    }

    @Override
    public EList<EClass> getStereotypes() {
        if (this.stereotypes == null) {
            this.stereotypes = new EObjectResolvingEList(EClass.class, (InternalEObject)this, 4);
        }
        return this.stereotypes;
    }

    @Override
    public int getMultiplicity() {
        return this.multiplicity;
    }

    @Override
    public void setMultiplicity(int newMultiplicity) {
        int oldMultiplicity = this.multiplicity;
        this.multiplicity = newMultiplicity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldMultiplicity, this.multiplicity));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getConstraints()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getConstraints()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getConstraints();
            }
            case 2: {
                return this.getElementMultiplicity();
            }
            case 3: {
                if (resolve) {
                    return this.getElement();
                }
                return this.basicGetElement();
            }
            case 4: {
                return this.getStereotypes();
            }
            case 5: {
                return this.getMultiplicity();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getConstraints().clear();
                this.getConstraints().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setElementMultiplicity((Integer)newValue);
                return;
            }
            case 3: {
                this.setElement((EClass)newValue);
                return;
            }
            case 4: {
                this.getStereotypes().clear();
                this.getStereotypes().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setMultiplicity((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getConstraints().clear();
                return;
            }
            case 2: {
                this.setElementMultiplicity(1);
                return;
            }
            case 3: {
                this.setElement(null);
                return;
            }
            case 4: {
                this.getStereotypes().clear();
                return;
            }
            case 5: {
                this.setMultiplicity(-1);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.constraints != null && !this.constraints.isEmpty();
            }
            case 2: {
                return this.elementMultiplicity != 1;
            }
            case 3: {
                return this.element != null;
            }
            case 4: {
                return this.stereotypes != null && !this.stereotypes.isEmpty();
            }
            case 5: {
                return this.multiplicity != -1;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == DisplayUnit.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == DisplayUnit.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (elementMultiplicity: ");
        result.append(this.elementMultiplicity);
        result.append(", multiplicity: ");
        result.append(this.multiplicity);
        result.append(')');
        return result.toString();
    }
}

