/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.richtext.celleditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RichTextCellEditor;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditor;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.ui.editors.UMLRichTextEditorConfiguration;
import org.eclipse.papyrus.uml.ui.editors.UMLRichtextEditorWithReferences;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class RichTextCellEditorWithUMLReferences
extends RichTextCellEditor {
    public RichTextCellEditorWithUMLReferences() {
        this(16);
    }

    public RichTextCellEditorWithUMLReferences(int style) {
        this(new UMLRichTextEditorConfiguration(), style);
    }

    public RichTextCellEditorWithUMLReferences(UMLRichTextEditorConfiguration toolbarConfiguration, int style) {
        super((RichTextEditorConfiguration)toolbarConfiguration, style);
    }

    public RichTextCellEditorWithUMLReferences(UMLRichTextEditorConfiguration toolbarConfiguration) {
        this(toolbarConfiguration, 16);
    }

    protected RichTextEditor createRichTextEditor(Composite parent) {
        return new UMLRichtextEditorWithReferences(parent, this.style){

            protected int getMinimumHeight() {
                return RichTextCellEditorWithUMLReferences.this.getMinimumDimension().y;
            }

            protected int getMinimumWidth() {
                return RichTextCellEditorWithUMLReferences.this.getMinimumDimension().x;
            }
        };
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        List<Object> objects;
        Control ctrl = super.activateCell(parent, originalCanonicalValue);
        if (this.editor instanceof GenericRichTextEditor && (objects = this.organizeEditedObjectAndFeature()) != null && 2 == objects.size()) {
            EObject realEditedObject = (EObject)objects.get(0);
            EStructuralFeature realFeature = (EStructuralFeature)objects.get(1);
            ((GenericRichTextEditor)this.editor).configureEdition(realEditedObject, realFeature);
        }
        return ctrl;
    }

    private List<Object> organizeEditedObjectAndFeature() {
        String id;
        List stereotypesWithEditedFeatureAppliedOnElement;
        INattableModelManager manager = (INattableModelManager)this.configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        int columnIndex = this.layerCell.getColumnIndex();
        int rowIndex = this.layerCell.getRowIndex();
        Object row = manager.getRowElement(rowIndex);
        Object column = manager.getColumnElement(columnIndex);
        row = AxisUtils.getRepresentedElement((Object)row);
        column = AxisUtils.getRepresentedElement((Object)column);
        Element editedElement = null;
        Object feature = null;
        if (row instanceof EObject && (column instanceof EStructuralFeature || column instanceof String)) {
            editedElement = (Element)row;
            feature = column;
        } else if (column instanceof EObject && (row instanceof EStructuralFeature || row instanceof String)) {
            editedElement = (Element)column;
            feature = row;
        } else {
            return null;
        }
        EStructuralFeature realFeature = null;
        Element realEditedObject = null;
        if (feature instanceof EStructuralFeature) {
            realFeature = (EStructuralFeature)feature;
            realEditedObject = editedElement;
        } else if (feature instanceof String && 1 == (stereotypesWithEditedFeatureAppliedOnElement = UMLTableUtils.getAppliedStereotypesWithThisProperty((Element)editedElement, (String)(id = AxisUtils.getPropertyId((Object)feature)))).size()) {
            realEditedObject = editedElement.getStereotypeApplication((Stereotype)stereotypesWithEditedFeatureAppliedOnElement.get(0));
            Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)editedElement, (String)id);
            if (prop.getName() != null) {
                realFeature = realEditedObject.eClass().getEStructuralFeature(prop.getName());
            }
        }
        if (realEditedObject != null && realFeature != null) {
            ArrayList<Object> returnedValue = new ArrayList<Object>();
            returnedValue.add(realEditedObject);
            returnedValue.add(realFeature);
        }
        return null;
    }

    protected EStructuralFeature getEditedFeature() {
        List<Object> objects = this.organizeEditedObjectAndFeature();
        if (objects != null && 2 == objects.size()) {
            return (EStructuralFeature)objects.get(1);
        }
        return null;
    }

    protected Element getEditedElement() {
        EObject eobject = this.getEditedEObject();
        if (eobject instanceof Element) {
            return (Element)eobject;
        }
        return null;
    }

    private EObject getEditedEObject() {
        List<Object> objects = this.organizeEditedObjectAndFeature();
        if (objects != null && 2 == objects.size()) {
            return (EObject)objects.get(0);
        }
        return null;
    }

    protected Point getMinimumDimension() {
        return new Point(370, 400);
    }
}

