/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.rotative;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sirius.uml.diagram.common.rotative.RotativeImageFigure;
import org.eclipse.papyrus.sirius.uml.diagram.common.rotative.RotativeImageHelper;
import org.eclipse.papyrus.sirius.uml.diagram.common.rotative.RotativeImageListener;
import org.eclipse.sirius.diagram.CustomStyle;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractNotSelectableShapeNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AirStyleDefaultSizeNodeFigure;

public class RotativeImageEditPart
extends AbstractNotSelectableShapeNodeEditPart
implements IStyleEditPart {
    private RotativeImageListener rotativeImageListener;
    private RotativeImageFigure rotativeImageFigure;
    private IFigure contentPane;

    public RotativeImageEditPart(View view) {
        super(view);
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = shape;
        return figure;
    }

    private NodeFigure createNodePlate() {
        AirStyleDefaultSizeNodeFigure result = new AirStyleDefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
        return result;
    }

    private IFigure createNodeShape() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof CustomStyle) {
            CustomStyle customStyle = (CustomStyle)element;
            String imagePath = RotativeImageHelper.getInstance().getImagePath(customStyle);
            this.rotativeImageFigure = new RotativeImageFigure(imagePath);
            this.rotativeImageListener = new RotativeImageListener(this);
            this.rotativeImageFigure.addFigureListener(this.rotativeImageListener);
            this.rotativeImageFigure.addAncestorListener(this.rotativeImageListener);
            this.rotativeImageFigure.addPropertyChangeListener(this.rotativeImageListener);
        }
        return this.rotativeImageFigure;
    }

    public void updateImage() {
        BorderedNodeFigure borderedNodeFigure;
        RotativeImageFigure shape = this.getPrimaryShape();
        if (shape != null && (borderedNodeFigure = RotativeImageHelper.getInstance().getBorderedNodeFigure((IGraphicalEditPart)this)) != null) {
            int side = DBorderItemLocator.findClosestSideOfParent((Rectangle)shape.getBounds(), (Rectangle)borderedNodeFigure.getBounds());
            shape.setOrientation(side);
        }
    }

    protected void refreshVisuals() {
        EObject element;
        super.refreshVisuals();
        RotativeImageFigure primaryShape = this.getPrimaryShape();
        if (primaryShape != null && (element = this.resolveSemanticElement()) instanceof CustomStyle) {
            CustomStyle imageStyle = (CustomStyle)element;
            primaryShape.refreshFigure(imageStyle);
            Dimension preferredSize = primaryShape.getPreferredSize();
            Rectangle rectangle = new Rectangle(0, 0, preferredSize.width, preferredSize.height);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rectangle);
        }
    }

    public RotativeImageFigure getPrimaryShape() {
        return this.rotativeImageFigure;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void createDefaultEditPolicies() {
    }

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    public void deactivate() {
        super.deactivate();
        this.rotativeImageFigure.removeFigureListener(this.rotativeImageListener);
        this.rotativeImageFigure.removeAncestorListener(this.rotativeImageListener);
        this.rotativeImageFigure.removePropertyChangeListener(this.rotativeImageListener);
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy result = super.getPrimaryDragEditPolicy();
        if (result instanceof ResizableEditPolicy) {
            ResizableEditPolicy ep = (ResizableEditPolicy)result;
            ep.setResizeDirections(0);
        }
        return result;
    }
}

