/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.sorted.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.block.procedure.checked.CheckedObjectIntProcedure;

class ImmutableSortedBagSerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSortedBag<T> bag;

    public ImmutableSortedBagSerializationProxy() {
    }

    ImmutableSortedBagSerializationProxy(ImmutableSortedBag<T> bag) {
        this.bag = bag;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.bag.sizeDistinct());
        out.writeObject(this.bag.comparator());
        try {
            this.bag.forEachWithOccurrences(new CheckedObjectIntProcedure<T>(){

                @Override
                public void safeValue(T object, int index) throws IOException {
                    out.writeObject(object);
                    out.writeInt(index);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        Comparator comparator = (Comparator)in.readObject();
        TreeBag<Object> deserializedBag = new TreeBag<Object>(comparator);
        for (int i = 0; i < size; ++i) {
            deserializedBag.addOccurrences(in.readObject(), in.readInt());
        }
        this.bag = deserializedBag.toImmutable();
    }

    protected Object readResolve() {
        return this.bag.toImmutable();
    }
}

