/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.file.AbstractFileEditor;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;

public class BundlePropertiesEditor
extends AbstractFileEditor {
    private Properties bundleConfig;
    private File bundleFile;
    private String filePath;

    public BundlePropertiesEditor(IProject project, String filePath) {
        super(project);
        this.filePath = filePath;
    }

    @Override
    public void init() {
        this.bundleFile = this.getBundleProperties();
        try {
            this.bundleConfig.load(new FileInputStream(this.bundleFile));
        }
        catch (FileNotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void createFiles(Set<String> files) {
    }

    @Override
    protected void doSave() {
    }

    public String getValue(String propertyName) {
        return this.bundleConfig.getProperty(propertyName);
    }

    private File getBundleProperties() {
        this.bundleFile = FileUtil.getWorkspaceFile((String)("/" + this.getProject().getName() + "/" + this.filePath + ".properties"));
        return this.bundleFile;
    }
}

