/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.swt.graphics.Image;

public class WrappingLabelWithScalableIcons
extends WrappingLabel {
    public static final int GAP_WIDTH = 4;

    public void paintFigure(Graphics graphics) {
        if (this.hasIcons()) {
            this.paintScaledIcons(graphics);
        }
    }

    protected Dimension getTotalIconSize() {
        int num = this.getNumberofIcons();
        if (num == 0) {
            return new Dimension(0, 0);
        }
        Rectangle r = this.getTextBounds();
        int width = 0;
        int i = 0;
        while (i < num) {
            Image icon = this.getIcon(i);
            if (icon != null) {
                org.eclipse.swt.graphics.Rectangle bounds = icon.getBounds();
                double scale = (double)(r.height - 2) / (double)bounds.height;
                if (scale > 1.0) {
                    scale = 1.0;
                }
                width += 4 + (int)((double)bounds.width * scale);
            }
            ++i;
        }
        return new Dimension(width, r.height);
    }

    private void paintScaledIcons(Graphics graphics) {
        if (this.getIconLocation() != null) {
            Point p = Point.SINGLETON;
            p.setLocation(this.getIconLocation());
            Rectangle figBounds = this.getBounds();
            p.x += figBounds.x;
            p.y += figBounds.y;
            Rectangle r = this.getTextBounds();
            int num = this.getNumberofIcons();
            int i = 0;
            while (i < num) {
                Image icon = this.getIcon(i);
                if (icon != null) {
                    org.eclipse.swt.graphics.Rectangle bounds = icon.getBounds();
                    double scale = (double)(r.height - 2) / (double)bounds.height;
                    if (scale > 1.0) {
                        scale = 1.0;
                    }
                    graphics.drawImage(icon, 0, 0, bounds.width, bounds.height, p.x, p.y, (int)((double)bounds.width * scale), (int)((double)bounds.height * scale));
                    p.x += 4 + (int)((double)bounds.width * scale);
                }
                ++i;
            }
        }
    }
}

