/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.configuration;

import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.filter.BooleanMatcherEditorFactory;
import org.eclipse.papyrus.infra.nattable.filter.IPapyrusMatcherEditorFactory;
import org.eclipse.papyrus.infra.nattable.filter.configuration.IFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.filter.validator.BooleanFilterDataValidator;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;

public abstract class AbstractBooleanComboBoxCellEditorFilterConfiguration
implements IFilterConfiguration {
    protected static final List<?> availableValue = Arrays.asList(CellHelper.getUnsupportedCellContentsText(), Boolean.TRUE, Boolean.FALSE);

    @Override
    public void configureFilter(IConfigRegistry configRegistry, Object columnElement, String configLabel) {
        ICellEditor editor = this.createICellEditor(configRegistry, columnElement, configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)editor, DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(NattableConfigAttributes.MATCHER_EDITOR_FACTORY, this.createMatcherFactory(), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)this.getDataValidator(configRegistry), DisplayMode.NORMAL, configLabel);
    }

    protected IPapyrusMatcherEditorFactory<Object> createMatcherFactory() {
        return new BooleanMatcherEditorFactory();
    }

    protected ICellEditor createICellEditor(IConfigRegistry configRegistry, Object columnElement, String configLabel) {
        return new ComboBoxCellEditor(availableValue);
    }

    protected IDataValidator getDataValidator(IConfigRegistry configRegistry) {
        return new BooleanFilterDataValidator();
    }

    @Override
    public String getConfigurationDescription() {
        return "This configuration provides an Combo to filter boolean values. Known values are true, false and N/A";
    }
}

