/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.tree.AbstractTreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;

public class TreeRowModel<T>
extends AbstractTreeRowModel<T> {
    protected final Set<Integer> parentIndexes = new HashSet<Integer>();

    public TreeRowModel(ITreeData<T> treeData) {
        super(treeData);
    }

    @Override
    public boolean isCollapsed(int index) {
        return this.parentIndexes.contains(index);
    }

    @Override
    public List<Integer> collapse(int index) {
        this.parentIndexes.add(index);
        this.notifyListeners();
        return this.getChildIndexes(index);
    }

    protected Collection<Integer> internalCollapse(int index) {
        this.parentIndexes.add(index);
        return this.getChildIndexes(index);
    }

    @Override
    public List<Integer> collapseAll() {
        HashSet<Integer> collapsedChildren = new HashSet<Integer>();
        int i = this.getTreeData().getElementCount() - 1;
        while (i >= 0) {
            if (this.hasChildren(i) && !this.isCollapsed(i)) {
                collapsedChildren.addAll(this.internalCollapse(i));
            }
            --i;
        }
        ArrayList<Integer> children = new ArrayList<Integer>(collapsedChildren);
        Collections.sort(children);
        this.notifyListeners();
        return children;
    }

    @Override
    public List<Integer> expand(int index) {
        ArrayList<Integer> children = new ArrayList<Integer>(this.internalExpand(index));
        Collections.sort(children);
        this.notifyListeners();
        return children;
    }

    protected Collection<Integer> internalExpand(int index) {
        this.parentIndexes.remove(index);
        List<Integer> directChildren = this.getDirectChildIndexes(index);
        HashSet<Integer> expandedChildren = new HashSet<Integer>(directChildren);
        for (Integer child : directChildren) {
            if (!this.hasChildren(child) || this.isCollapsed(child)) continue;
            expandedChildren.addAll(this.internalExpand(child));
        }
        return expandedChildren;
    }

    @Override
    public List<Integer> expandAll() {
        HashSet<Integer> expandedChildren = new HashSet<Integer>();
        for (int index : this.parentIndexes) {
            expandedChildren.addAll(this.getChildIndexes(index));
        }
        this.parentIndexes.clear();
        ArrayList<Integer> children = new ArrayList<Integer>(expandedChildren);
        Collections.sort(children);
        this.notifyListeners();
        return children;
    }

    @Override
    public List<Integer> expandToLevel(int level) {
        HashSet<Integer> expandedChildren = new HashSet<Integer>();
        ArrayList<Integer> parentCopy = new ArrayList<Integer>(this.parentIndexes);
        Iterator iterator = parentCopy.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            expandedChildren.addAll(this.internalExpandToLevel(index, level));
        }
        ArrayList<Integer> children = new ArrayList<Integer>(expandedChildren);
        Collections.sort(children);
        this.notifyListeners();
        return children;
    }

    @Override
    public List<Integer> expandToLevel(int parentIndex, int level) {
        ArrayList<Integer> children = new ArrayList<Integer>(this.internalExpandToLevel(parentIndex, level));
        Collections.sort(children);
        this.notifyListeners();
        return children;
    }

    protected Collection<Integer> internalExpandToLevel(int index, int level) {
        HashSet<Integer> expandedChildren = new HashSet<Integer>();
        if (this.depth(index) <= level - 1) {
            this.parentIndexes.remove(index);
            List<Integer> directChildren = this.getDirectChildIndexes(index);
            for (Integer child : directChildren) {
                expandedChildren.add(child);
                if (!this.hasChildren(child) || this.depth(child) > level - 1) continue;
                expandedChildren.addAll(this.internalExpandToLevel(child, level));
            }
        }
        return expandedChildren;
    }
}

