/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EcoreUtils;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLFactory;

public class CustomTimeObservationCreateCommand
extends EditElementCommand {
    public CustomTimeObservationCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        TimeObservation timeObservation = UMLFactory.eINSTANCE.createTimeObservation();
        CreateElementRequest request = (CreateElementRequest)this.getRequest();
        EditPart originalTarget = (EditPart)request.getParameter("ORIGINAL_TARGET");
        NamedElement targetElement = (NamedElement)((View)originalTarget.getModel()).getElement();
        Package containingPackage = EcoreUtils.getContaining(request.getContainer(), Package.class);
        if (containingPackage == null) {
            return CommandResult.newErrorCommandResult((String)"The container must be in a Package");
        }
        containingPackage.getPackagedElements().add((Object)timeObservation);
        timeObservation.setEvent(targetElement);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)timeObservation);
        return CommandResult.newOKCommandResult((Object)timeObservation);
    }
}

