/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.widgets.celleditors.composite;

import org.eclipse.papyrus.emf.facet.custom.metamodel.custompt.IImage;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.custom.ui.ImageUtils;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ImageComposite
extends AbstractCellEditorComposite<IImage> {
    private final Button compositeButton;
    private final Canvas compositeCanvas;
    private IImage valueImage;

    protected Button getButton() {
        return this.compositeButton;
    }

    public Canvas getCanvas() {
        return this.compositeCanvas;
    }

    public ImageComposite(Composite parent) {
        super(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.setLayout((Layout)layout);
        this.compositeCanvas = this.createCanvas((Composite)this);
        this.compositeButton = this.createButton((Composite)this);
        Listener disposeListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == ImageComposite.this.getParent().getShell() && event.widget != ImageComposite.this.getButton() && event.widget != ImageComposite.this.getCanvas()) {
                    ImageComposite.this.dispose();
                    Display.getDefault().removeFilter(3, (Listener)this);
                }
            }
        };
        Display.getDefault().addFilter(3, disposeListener);
    }

    protected Canvas createCanvas(Composite parent) {
        Canvas canvas = new Canvas(parent, 0);
        canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image img = ImageComposite.this.getImage();
                if (img != null && !img.isDisposed()) {
                    e.gc.drawImage(img, 0, 0);
                }
            }
        });
        return canvas;
    }

    protected Button createButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("+");
        GridData data = new GridData(4, 4, false, true);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageComposite.this.openShell();
            }
        });
        return button;
    }

    protected void openShell() {
        Shell shell = new Shell();
        shell.setText(Messages.ImageComposite_fullImage);
        shell.setLayout((Layout)new GridLayout());
        Canvas shellCanvas = this.createCanvas((Composite)shell);
        GridData canvasData = new GridData(4, 4, true, true);
        Image img = this.getImage();
        if (img != null && !img.isDisposed()) {
            canvasData.widthHint = img.getBounds().width;
            canvasData.heightHint = img.getBounds().height;
        }
        shellCanvas.setLayoutData((Object)canvasData);
        shell.pack();
        shell.open();
    }

    protected Image getImage() {
        return ImageUtils.unwrap((IImage)this.valueImage);
    }

    public IImage getValue() {
        return this.valueImage;
    }

    public void setValue(IImage value) {
        this.valueImage = value;
    }
}

