/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InformationItem;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLKeywordLabelSwitch
extends UMLSwitch<String> {
    private static final String ST_LEFT = "\u00ab";
    private static final String ST_RIGHT = "\u00bb";
    private static final String INFORMATION_ITEM_KEYWORD = "Information";
    private static final String METACLASS_KEYWORD = "Metaclass";
    private static final String PRIMITIVE_TYPE_KEYWORD = "Primitive";
    private static final String SUBSTITUTION_KEYWORD = "substitute";

    private String getMetaclassName(Element element) {
        if (element != null) {
            return element.eClass().getName();
        }
        return null;
    }

    private String buildKeywordString(String keyword) {
        if (keyword == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ST_LEFT);
        builder.append(keyword);
        builder.append(ST_RIGHT);
        return builder.toString();
    }

    public String caseAbstraction(Abstraction abstraction) {
        return this.buildKeywordString(this.getMetaclassName((Element)abstraction).toLowerCase());
    }

    public String caseClass(Class clazz) {
        if (clazz.isMetaclass()) {
            return this.buildKeywordString(METACLASS_KEYWORD);
        }
        return null;
    }

    public String caseComponent(Component component) {
        return this.buildKeywordString(this.getMetaclassName((Element)component));
    }

    public String caseDataType(DataType datatype) {
        return this.buildKeywordString(this.getMetaclassName((Element)datatype));
    }

    public String caseElementImport(ElementImport elementImport) {
        return this.buildKeywordString(this.getMetaclassName((Element)elementImport).toLowerCase());
    }

    public String caseEnumeration(Enumeration enumeration) {
        return this.buildKeywordString(this.getMetaclassName((Element)enumeration));
    }

    public String caseInformationItem(InformationItem informationItem) {
        return this.buildKeywordString(INFORMATION_ITEM_KEYWORD);
    }

    public String caseInterface(Interface interface_) {
        return this.buildKeywordString(this.getMetaclassName((Element)interface_));
    }

    public String casePrimitiveType(PrimitiveType primitiveType) {
        return this.buildKeywordString(PRIMITIVE_TYPE_KEYWORD);
    }

    public String caseSignal(Signal signal) {
        return this.buildKeywordString(this.getMetaclassName((Element)signal));
    }

    public String caseSubstitution(Substitution substitution) {
        return this.buildKeywordString(SUBSTITUTION_KEYWORD);
    }
}

