/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleObjectMapFactory;
import org.eclipse.collections.api.map.primitive.DoubleObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleObjectMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleObjectMap;
import org.eclipse.collections.impl.factory.primitive.DoubleObjectMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleObjectSingletonMap;

public class ImmutableDoubleObjectMapFactoryImpl
implements ImmutableDoubleObjectMapFactory {
    public static final ImmutableDoubleObjectMapFactory INSTANCE = new ImmutableDoubleObjectMapFactoryImpl();

    @Override
    public <V> ImmutableDoubleObjectMap<V> empty() {
        return ImmutableDoubleObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> of(double key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> with(double key, V value) {
        return new ImmutableDoubleObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> ofAll(DoubleObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> withAll(DoubleObjectMap<? extends V> map) {
        if (map instanceof ImmutableDoubleObjectMap) {
            return (ImmutableDoubleObjectMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            double[] array = new double[1];
            map.forEachKey(each -> {
                array[0] = each;
            });
            return new ImmutableDoubleObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableDoubleObjectHashMap<V>(map);
    }

    @Override
    public <T, V> ImmutableDoubleObjectMap<V> from(Iterable<T> iterable, DoubleFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableDoubleObjectMap<V> map = DoubleObjectMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map.toImmutable();
    }
}

