/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.event.DataUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDataCommandHandler
extends AbstractLayerCommandHandler<UpdateDataCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateDataCommandHandler.class);
    private final DataLayer dataLayer;
    private final boolean performEqualsCheck;

    public UpdateDataCommandHandler(DataLayer dataLayer) {
        this(dataLayer, true);
    }

    public UpdateDataCommandHandler(DataLayer dataLayer, boolean performEqualsCheck) {
        this.dataLayer = dataLayer;
        this.performEqualsCheck = performEqualsCheck;
    }

    @Override
    public Class<UpdateDataCommand> getCommandClass() {
        return UpdateDataCommand.class;
    }

    @Override
    protected boolean doCommand(UpdateDataCommand command) {
        try {
            int columnPosition = command.getColumnPosition();
            int rowPosition = command.getRowPosition();
            Object currentValue = this.dataLayer.getDataValueByPosition(columnPosition, rowPosition);
            if (!this.performEqualsCheck || currentValue == null && command.getNewValue() != null || command.getNewValue() == null && currentValue != null || currentValue != null && command.getNewValue() != null && !currentValue.equals(command.getNewValue())) {
                this.dataLayer.setDataValueByPosition(columnPosition, rowPosition, command.getNewValue());
                this.dataLayer.fireLayerEvent(new DataUpdateEvent(this.dataLayer, columnPosition, rowPosition, currentValue, command.getNewValue()));
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to update value to: {}", command.getNewValue(), (Object)e);
            return false;
        }
    }
}

