/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.profile.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectionDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.sirius.uml.diagram.profile.Activator;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.create.CreationStatus;
import org.eclipse.papyrus.uml.domain.services.create.ElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.create.ElementCreator;
import org.eclipse.papyrus.uml.domain.services.create.IElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.modify.IFeatureModifier;
import org.eclipse.papyrus.uml.tools.providers.UMLMetaclassContentProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class ProfileDiagramServices
extends AbstractDiagramServices {
    public void importMetaClass(Profile profile, DSemanticDecorator containerView) {
        List<? extends PackageableElement> metaClassesToAdd = this.selectNewMetaclasses(profile);
        if (!metaClassesToAdd.isEmpty()) {
            this.addMetaclass(profile, metaClassesToAdd, containerView);
            metaClassesToAdd.forEach(metaClass -> {
                if (!this.isMetaClassAlreadyRepresented(containerView, (PackageableElement)metaClass)) {
                    this.createMetaclassNode(profile, containerView, (PackageableElement)metaClass);
                }
            });
        }
    }

    private List<? extends PackageableElement> selectNewMetaclasses(Profile profile) {
        List<Object> addedMetaClasses = new ArrayList();
        ReferenceSelector selector = new ReferenceSelector(true);
        selector.setContentProvider((IStaticContentProvider)new UMLMetaclassContentProvider((Element)profile));
        LabelProviderService serv = null;
        try {
            serv = (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)profile);
        }
        catch (ServiceException e) {
            Activator.log.error("Label Provider Service not found", (Throwable)e);
        }
        ILabelProvider labelProvider = serv.getLabelProvider();
        selector.setLabelProvider(labelProvider);
        ArrayList alreadyImportedElement = new ArrayList();
        MultipleValueSelectionDialog dialog = new MultipleValueSelectionDialog(Display.getDefault().getActiveShell(), (IElementSelector)selector, "Select Metaclass", true, false, -1);
        dialog.setContextElement((Object)profile);
        dialog.setLabelProvider(labelProvider);
        dialog.setInitialElementSelections(alreadyImportedElement);
        if (dialog.open() == 0) {
            Object[] selectedMetaclass = dialog.getResult();
            addedMetaClasses = Arrays.stream(selectedMetaclass).filter(PackageableElement.class::isInstance).map(PackageableElement.class::cast).collect(Collectors.toList());
        }
        return addedMetaClasses;
    }

    private void addMetaclass(Profile profile, List<? extends PackageableElement> metaClassesToAdd, DSemanticDecorator containerView) {
        ElementCreator elementCreator = new ElementCreator((IElementConfigurer)new ElementConfigurer(), (IFeatureModifier)new ElementFeatureModifier(this.getECrossReferenceAdapter((EObject)profile), (IEditableChecker)new EditableChecker()));
        EList metaclassSet = profile.getReferencedMetaclasses();
        int i = 0;
        while (i < metaClassesToAdd.size()) {
            if (!metaclassSet.contains((Object)metaClassesToAdd.get(i))) {
                PackageableElement importedMetaClass = metaClassesToAdd.get(i);
                ElementImport added = null;
                EList list = profile.getElementImports();
                int iter = 0;
                while (iter < list.size()) {
                    if (list.get(iter) != null && ((ElementImport)list.get(iter)).getImportedElement() != null && importedMetaClass.getQualifiedName().equals(((ElementImport)list.get(iter)).getImportedElement().getQualifiedName())) {
                        added = (ElementImport)list.get(iter);
                        break;
                    }
                    ++iter;
                }
                if (added == null) {
                    CreationStatus creationStatus = elementCreator.create((EObject)profile, UMLPackage.eINSTANCE.getElementImport().getName(), UMLPackage.eINSTANCE.getProfile_MetaclassReference().getName());
                    added = Optional.ofNullable(creationStatus.getElement()).filter(ElementImport.class::isInstance).map(ElementImport.class::cast).orElse(null);
                    if (added != null) {
                        added.setImportedElement(importedMetaClass);
                        added.setAlias(importedMetaClass.getName());
                    }
                }
            }
            ++i;
        }
    }

    private void createMetaclassNode(Profile profile, DSemanticDecorator containerView, PackageableElement metaClass) {
        Session session = SessionManager.INSTANCE.getSession((EObject)profile);
        this.createView((EObject)metaClass, containerView, session, "aql:containerView");
    }

    private boolean isMetaClassAlreadyRepresented(DSemanticDecorator containerView, PackageableElement metaClass) {
        EList dDiagramElements = List.of();
        if (containerView instanceof DSemanticDiagram) {
            dDiagramElements = ((DSemanticDiagram)containerView).getOwnedDiagramElements();
        } else if (containerView instanceof DNodeContainer) {
            dDiagramElements = ((DNodeContainer)containerView).getOwnedDiagramElements();
        }
        Optional<DDiagramElement> optionalExistingDiagramElement = dDiagramElements.stream().filter(element -> element.getTarget().equals(metaClass)).findFirst();
        return optionalExistingDiagramElement.isPresent();
    }
}

