/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ViewpointExplorer
extends ViewPart {
    private TreeViewer tree;
    private IPartListener listener;
    private ComposedAdapterFactory adapterFactory = new ViewpointAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private AdapterFactoryContentProvider contentProvider = this.createContentProvider((AdapterFactory)this.adapterFactory);
    private AdapterFactoryLabelProvider labelProvider = this.createLabelProvider((AdapterFactory)this.adapterFactory);
    private AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, null, new HashMap()){

        public boolean isReadOnly(Resource resource) {
            return true;
        }
    };

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        Composite inner = new Composite(parent, 0);
        inner.setLayoutData((Object)new GridData(1808));
        inner.setLayout((Layout)new FillLayout());
        this.tree = new TreeViewer(inner, 2816);
        this.tree.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tree.setContentProvider((IContentProvider)this.contentProvider);
        this.listener = this.createSelectionListener(this.tree);
        this.getSite().getPage().addPartListener(this.listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tree);
    }

    AdapterFactoryLabelProvider createLabelProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryLabelProvider(adapterFactory){

            public String getText(Object object) {
                return super.getText(ViewpointExplorer.this.unwrapPropertySource(object));
            }

            public Image getImage(Object object) {
                return super.getImage(ViewpointExplorer.this.unwrapPropertySource(object));
            }

            public StyledString getStyledText(Object object) {
                return super.getStyledText(ViewpointExplorer.this.unwrapPropertySource(object));
            }
        };
    }

    AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryContentProvider(adapterFactory){

            public Object[] getElements(Object object) {
                Object[] result = object instanceof Collection ? ((Collection)object).toArray() : (object instanceof Object[] ? (Object[])object : super.getElements(object));
                return ViewpointExplorer.this.getPropertySources(result);
            }

            public boolean hasChildren(Object object) {
                return super.hasChildren(ViewpointExplorer.this.unwrapPropertySource(object));
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                Object[] result = super.getChildren(ViewpointExplorer.this.unwrapPropertySource(parentElement));
                return ViewpointExplorer.this.getPropertySources(result);
            }
        };
    }

    public void dispose() {
        this.labelProvider.dispose();
        this.adapterFactory.dispose();
        if (this.listener != null) {
            this.getSite().getPage().removePartListener(this.listener);
        }
    }

    public void setFocus() {
    }

    private IPartListener createSelectionListener(final TreeViewer viewer) {
        return new IPartListener(){
            private IWorkbenchPart editor;

            public void partActivated(IWorkbenchPart part) {
                ResourceSet resourceSet;
                EditingDomain domain;
                if (part == this.editor) {
                    viewer.refresh();
                } else if (part instanceof IMultiDiagramEditor && (domain = (EditingDomain)part.getAdapter(EditingDomain.class)) != null && (resourceSet = domain.getResourceSet()) instanceof ModelSet) {
                    this.editor = part;
                    ArchitectureDescriptionUtils utils = new ArchitectureDescriptionUtils((ModelSet)resourceSet);
                    viewer.setInput(List.of(utils.getArchitectureContext()));
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                boolean cfr_ignored_0 = part instanceof IMultiDiagramEditor;
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == this.editor) {
                    viewer.setInput(null);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                boolean cfr_ignored_0 = part instanceof IMultiDiagramEditor;
            }

            public void partOpened(IWorkbenchPart part) {
                boolean cfr_ignored_0 = part instanceof IMultiDiagramEditor;
            }
        };
    }

    public Object[] getPropertySources(Object[] objects) {
        ArrayList<Object> propertySources = new ArrayList<Object>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            propertySources.add(this.getPropertySource(object));
            ++n2;
        }
        return propertySources.toArray();
    }

    public Object getPropertySource(Object object) {
        return this.contentProvider.getPropertySource(object);
    }

    Object unwrapPropertySource(Object object) {
        return object instanceof PropertySource ? ((PropertySource)object).getObject() : object;
    }

    private class ViewpointAdapterFactory
    extends ComposedAdapterFactory
    implements IEditingDomainProvider {
        public ViewpointAdapterFactory(ComposedAdapterFactory.Descriptor.Registry adapterFactoryDescriptorRegistry) {
            super(adapterFactoryDescriptorRegistry);
        }

        public EditingDomain getEditingDomain() {
            return ViewpointExplorer.this.editingDomain;
        }
    }
}

