/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.emf.readonly.spi.IReadOnlyManagerProcessor;
import org.eclipse.papyrus.infra.tools.util.CoreExecutors;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.emf.readonly";
    private static Activator plugin;
    public static LogHelper log;
    private static final IReadOnlyManagerProcessor[] NO_PROCESSORS;
    private Executor readOnlyCacheExecutor;
    private ServiceTracker<IReadOnlyManagerProcessor, IReadOnlyManagerProcessor> roManagerProcessorTracker;

    static {
        NO_PROCESSORS = new IReadOnlyManagerProcessor[0];
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
        this.roManagerProcessorTracker = new ServiceTracker(context, IReadOnlyManagerProcessor.class, null);
        this.roManagerProcessorTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.roManagerProcessorTracker.close();
        this.roManagerProcessorTracker = null;
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public synchronized Executor getReadOnlyCacheExecutor() {
        if (this.readOnlyCacheExecutor == null) {
            this.readOnlyCacheExecutor = CoreExecutors.getUIExecutorService();
        }
        return this.readOnlyCacheExecutor;
    }

    public synchronized Executor setReadOnlyCacheExecutor(Executor executor) {
        Executor result = this.getReadOnlyCacheExecutor();
        this.readOnlyCacheExecutor = executor;
        return result;
    }

    Iterable<IReadOnlyManagerProcessor> getReadOnlyManagerProcessors() {
        IReadOnlyManagerProcessor[] processors = (IReadOnlyManagerProcessor[])this.roManagerProcessorTracker.getServices((Object[])NO_PROCESSORS);
        return processors == null ? Collections.emptyList() : Arrays.asList(processors);
    }
}

