/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.welcome.internal.modelelements;

import java.util.function.Supplier;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.infra.gmfdiag.welcome.internal.modelelements.NotationObservable;
import org.eclipse.papyrus.infra.gmfdiag.welcome.internal.modelelements.WelcomeModelElement;
import org.eclipse.papyrus.infra.tools.databinding.WritableListWithIterator;
import org.eclipse.papyrus.infra.ui.util.TransactionUIHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.widgets.Display;

public class NotationObservableProperty
implements Supplier<IObservableList<NotationObservable>> {
    private TransactionalEditingDomain domain;
    private ResourceAdapter.Transactional diagramsListener;
    private IObservableList<NotationObservable> list = new WritableListWithIterator.Containment(NotationObservable.class);

    public NotationObservableProperty(WelcomeModelElement owner) {
        this.domain = (TransactionalEditingDomain)owner.getDomain();
        this.hookDiagramsListener();
        this.list.addDisposeListener(event -> {
            this.diagramsListener.uninstall(this.domain);
            this.diagramsListener = null;
            this.domain = null;
        });
    }

    @Override
    public IObservableList<NotationObservable> get() {
        return this.list;
    }

    void hookDiagramsListener() {
        this.diagramsListener = new ResourceAdapter.Transactional(){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                if (Display.getCurrent() != null) {
                    this.basicResourceSetChanged(event);
                } else {
                    this.handleResourceSetChangeEvent(event, TransactionUIHelper.getExecutor((TransactionalEditingDomain)NotationObservableProperty.this.domain));
                }
            }

            final void basicResourceSetChanged(ResourceSetChangeEvent event) {
                super.resourceSetChanged(event);
            }

            protected void handleResourceLoaded(Resource resource) {
                resource.getContents().stream().filter(ViewPrototype::isViewObject).filter(NotationObservableProperty.this::isUserObject).filter(arg_0 -> NotationObservableProperty.access$1(NotationObservableProperty.this, arg_0)).map(NotationObservable::new).forEach(arg_0 -> NotationObservableProperty.this.list.add(arg_0));
            }

            protected void handleRootAdded(Resource resource, EObject root) {
                if (ViewPrototype.isViewObject((EObject)root) && NotationObservableProperty.this.isUserObject(root)) {
                    NotationObservableProperty.this.list.add((Object)new NotationObservable(root));
                }
            }

            protected void handleRootRemoved(Resource resource, EObject root) {
                if (ViewPrototype.isViewObject((EObject)root)) {
                    NotationObservableProperty.this.list.removeIf(next -> next.getView().getValue() == root);
                }
            }
        };
        this.diagramsListener.install(this.domain);
    }

    boolean isUserObject(EObject object) {
        URI uri;
        ResourceSet rset;
        Resource resource = object.eResource();
        ResourceSet resourceSet = rset = resource == null ? null : resource.getResourceSet();
        boolean result = rset instanceof ModelSet ? ((ModelSet)rset).isUserModelResource(resource.getURI()) : (resource != null ? (uri = resource.getURI()).isPlatformResource() || uri.isFile() : false);
        return result;
    }

    private boolean notAddedYet(EObject object) {
        return this.list.stream().allMatch(obs -> obs.getView().getValue() != object);
    }

    static /* synthetic */ boolean access$1(NotationObservableProperty notationObservableProperty, EObject eObject) {
        return notationObservableProperty.notAddedYet(eObject);
    }
}

