/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.papyrus.infra.widgets.databinding.StyledTextObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.selectors.StringSelector;
import org.eclipse.papyrus.infra.widgets.validator.AbstractValidator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class StyledTextStringEditor
extends AbstractValueEditor
implements KeyListener,
ModifyListener {
    protected final StyledText text;
    private int delay = 600;
    private boolean validateOnDelay = false;
    private Timer timer;
    private TimerTask currentValidateTask;
    private TimerTask changeColorTask;
    private static final int DEFAULT_HEIGHT_HINT = 55;
    private static final int DEFAULT_WIDTH_HINT = 100;

    public StyledTextStringEditor(Composite parent, int style) {
        this(parent, style, null, 55, 100);
    }

    public StyledTextStringEditor(Composite parent, int style, AbstractValidator targetValidator) {
        this(parent, style, null, 55, 100, targetValidator);
    }

    public StyledTextStringEditor(Composite parent, int style, String label) {
        this(parent, style, label, 55, 100);
    }

    public StyledTextStringEditor(Composite parent, int style, String label, AbstractValidator targetValidator) {
        this(parent, style, label, 55, 100, targetValidator);
    }

    public StyledTextStringEditor(Composite parent, int style, int heighHint, int widthHint) {
        this(parent, style, null, heighHint, widthHint);
    }

    public StyledTextStringEditor(Composite parent, int style, String label, int heighHint, int widthHint) {
        this(parent, style, label, heighHint, widthHint, null);
    }

    public StyledTextStringEditor(Composite parent, int style, String label, int heighHint, int widthHint, AbstractValidator targetValidator) {
        super(parent, label);
        this.targetValidator = targetValidator;
        GridData data = this.getDefaultLayoutData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        int styledTextStyle = style;
        if ((style & 2) != 0) {
            data.minimumHeight = heighHint;
            data.minimumWidth = widthHint;
            styledTextStyle = style | 0x200;
        }
        this.text = this.createStyledText(this, null, styledTextStyle);
        this.text.setLayoutData((Object)data);
        if (label != null) {
            this.label.setLayoutData((Object)this.getLabelLayoutData());
        }
        this.text.addKeyListener((KeyListener)this);
        this.text.addModifyListener((ModifyListener)this);
        this.setCommitOnFocusLost((Control)this.text);
        this.controlDecoration = new ControlDecoration((Control)this.text, 16512);
        this.controlDecoration.hide();
        GridLayout layout = (GridLayout)this.getLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.pack();
    }

    public StyledText createStyledText(Composite parent, String value, int style) {
        StyledText txt = new StyledText(parent, style);
        txt.setText(value);
        return txt;
    }

    @Override
    protected GridData getLabelLayoutData() {
        GridData result = super.getLabelLayoutData();
        if (this.text != null && (this.text.getStyle() & 2) != 0) {
            result.verticalAlignment = 1;
        }
        return result;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            if ((this.text.getStyle() & 2) == 0) {
                if (e.stateMask == 0) {
                    this.notifyChange();
                }
            } else if (e.stateMask == 262144) {
                String str = this.text.getText();
                if (str.endsWith(StringSelector.LINE_SEPARATOR)) {
                    int newLength = str.length() - StringSelector.LINE_SEPARATOR.length();
                    this.text.setText(str.substring(0, newLength));
                    this.text.setSelection(newLength);
                }
                this.notifyChange();
            }
        }
    }

    @Override
    public void setModelObservable(IObservableValue observable) {
        this.setWidgetObservable((IObservableValue)new StyledTextObservableValue(this.text, observable, 16), true);
        super.setModelObservable(observable);
    }

    @Override
    public Object getEditableType() {
        return String.class;
    }

    @Override
    public Object getValue() {
        return this.text.getText();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.text.setEnabled(!readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return !this.text.isEnabled();
    }

    protected void notifyChange() {
        this.text.notifyListeners(16, new Event());
        this.commit();
        this.changeColorField();
    }

    public void setToolTipText(String tooltip) {
        this.text.setToolTipText(tooltip);
        super.setLabelToolTipText(tooltip);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.text.setText((String)value);
        } else {
            this.text.setText("");
        }
    }

    public void setValidateOnDelay(boolean validateOnDelay) {
        this.validateOnDelay = validateOnDelay;
        if (validateOnDelay) {
            this.text.addModifyListener((ModifyListener)this);
        } else {
            this.text.removeModifyListener((ModifyListener)this);
            this.cancelCurrentTask();
        }
    }

    public void setValidateOnDelay(int millis) {
        this.delay = millis;
        this.setValidateOnDelay(true);
        if (this.delay == 0) {
            this.cancelCurrentTask();
        }
    }

    private void cancelCurrentTask() {
        if (this.currentValidateTask != null) {
            this.currentValidateTask.cancel();
            this.currentValidateTask = null;
        }
    }

    public void modifyText(ModifyEvent e) {
        IStatus status;
        if (this.validateOnDelay) {
            if (this.delay == 0) {
                this.commit();
                return;
            }
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.cancelCurrentTask();
            this.currentValidateTask = new TimerTask(){

                @Override
                public void run() {
                    StyledTextStringEditor.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            StyledTextStringEditor.this.commit();
                        }
                    });
                }
            };
            this.timer.schedule(this.currentValidateTask, this.delay);
        }
        if (this.targetValidator != null) {
            status = this.targetValidator.validate(this.getTextToValidate());
            this.updateStatus(status);
        }
        if (this.modelValidator != null) {
            status = this.modelValidator.validate((Object)this.getTextToValidate());
            this.updateStatus(status);
            if (this.binding == null) {
                this.update();
            }
        }
        if (this.modelProperty != null) {
            if (this.modelProperty.getValue() != null) {
                if (!this.isReadOnly() && !this.modelProperty.getValue().toString().equals(this.text.getText())) {
                    this.text.setBackground(EDIT);
                } else {
                    this.text.setBackground(DEFAULT);
                }
            } else if (this.text.getText().equals("")) {
                this.text.setBackground(DEFAULT);
            } else {
                this.text.setBackground(EDIT);
            }
        }
    }

    protected String getTextToValidate() {
        return this.text.getText();
    }

    public void dispose() {
        this.cancelCurrentTask();
        this.cancelChangeColorTask();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        super.dispose();
    }

    public StyledText getText() {
        return this.text;
    }

    @Override
    public void updateStatus(IStatus status) {
        if (!this.isDisposed()) {
            switch (status.getSeverity()) {
                case 0: {
                    this.controlDecoration.hide();
                    break;
                }
                case 2: {
                    FieldDecoration warning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                    this.controlDecoration.setImage(warning.getImage());
                    this.controlDecoration.showHoverText(status.getMessage());
                    this.controlDecoration.setDescriptionText(status.getMessage());
                    this.controlDecoration.show();
                    break;
                }
                case 4: {
                    FieldDecoration error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                    this.controlDecoration.setImage(error.getImage());
                    this.controlDecoration.showHoverText(status.getMessage());
                    this.controlDecoration.setDescriptionText(status.getMessage());
                    this.controlDecoration.show();
                    break;
                }
                default: {
                    this.controlDecoration.hide();
                }
            }
        }
    }

    @Override
    public void changeColorField() {
        if (this.binding != null) {
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.cancelChangeColorTask();
            this.changeColorTask = new TimerTask(){

                @Override
                public void run() {
                    if (StyledTextStringEditor.this.isDisposed()) {
                        return;
                    }
                    StyledTextStringEditor.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).StyledTextStringEditor.this.text.isDisposed()) {
                                (this).StyledTextStringEditor.this.text.setBackground(DEFAULT);
                                (this).StyledTextStringEditor.this.text.update();
                            }
                        }
                    });
                }
            };
            if (this.errorBinding) {
                if (!this.text.isDisposed()) {
                    this.text.setBackground(ERROR);
                    this.text.update();
                }
            } else {
                IStatus status = (IStatus)this.binding.getValidationStatus().getValue();
                switch (status.getSeverity()) {
                    case 0: 
                    case 2: {
                        this.timer.schedule(this.changeColorTask, 600L);
                        if (this.text.isDisposed()) break;
                        this.text.setBackground(VALID);
                        this.text.update();
                        break;
                    }
                    case 4: {
                        if (this.text.isDisposed()) break;
                        this.text.setBackground(ERROR);
                        this.text.update();
                    }
                }
            }
        }
    }

    private void cancelChangeColorTask() {
        if (this.changeColorTask != null) {
            this.changeColorTask.cancel();
            this.changeColorTask = null;
        }
    }
}

