/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.BundleExplorerDialog;
import org.eclipse.papyrus.infra.widgets.editors.StringWithClearEditor;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class BundleIconExplorerDialog
extends SelectionStatusDialog {
    protected static final String ASTERISK = "*";
    protected static final String EMPTY = "";
    protected static final String GIF_EXTENSION = ".gif";
    public static final int GIF_EXTENSION_LENGTH = ".gif".length();
    protected static final String PLUGIN_PROTOCOL = "platform:/plugin/";
    protected final boolean allowMultiple;
    protected FilteredList filteredList;
    protected String filter = null;
    protected String initialValue;
    protected String currentBundleName = "org.eclipse.uml2.uml.edit";
    private Text text;
    private String localPath = "";

    public BundleIconExplorerDialog(Shell parentShell, boolean allowMultiple, String initialValue, String bundle) {
        super(parentShell);
        this.allowMultiple = allowMultiple;
        this.initialValue = initialValue;
        this.currentBundleName = bundle;
        this.setTitle(Messages.BundleIconExplorerDialog_Title);
        this.setMessage(Messages.BundleIconExplorerDialog_Message);
    }

    public BundleIconExplorerDialog(Shell parentShell, String initialValue) {
        this(parentShell, false, initialValue, Activator.retrieveBundleId(initialValue));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.createComboArea(composite);
        this.createFilterText(composite);
        this.createFilteredList(composite);
        this.refreshList();
        return composite;
    }

    /*
     * Unable to fully structure code
     */
    protected void refreshList() {
        this.currentBundleName = this.text.getText().trim();
        bundle = Platform.getBundle((String)this.currentBundleName);
        if (bundle == null) {
            Activator.getDefault();
            Activator.log.log((IStatus)new Status(4, "org.eclipse.papyrus.infra.widgets", Messages.BundleIconExplorerDialog_CantFindBundleIdMessage + this.currentBundleName));
            return;
        }
        e = bundle.findEntries("", "*.gif", true);
        selectedProxy = new ArrayList<ImageProxy>();
        images = new ArrayList<ImageProxy>();
        if (e != null) ** GOTO lbl20
        return;
lbl-1000:
        // 1 sources

        {
            proxy = new ImageProxy((URL)e.nextElement());
            if (!proxy.isDisplayed()) continue;
            images.add(proxy);
            if (!proxy.isInitial()) continue;
            selectedProxy.add(proxy);
lbl20:
            // 4 sources

            ** while (e.hasMoreElements())
        }
lbl21:
        // 1 sources

        this.filteredList.setElements(images.toArray());
        if (!selectedProxy.isEmpty()) {
            this.filteredList.setSelection(selectedProxy.toArray());
        }
    }

    protected void createComboArea(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        parent.setLayoutData((Object)data);
        parent.setFont(parent.getFont());
        GridLayout layout = new GridLayout(3, false);
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        label.setText(Messages.BundleIconExplorerDialog_Bundle);
        this.text = new Text(parent, 2056);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.text.setLayoutData((Object)data);
        this.text.setText(this.currentBundleName);
        Button selectBundleButton = new Button(parent, 0);
        selectBundleButton.setText("...");
        selectBundleButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                BundleIconExplorerDialog.this.handleManageBundlesButtonPressed();
            }
        });
    }

    protected void handleManageBundlesButtonPressed() {
        BundleExplorerDialog dialog = new BundleExplorerDialog(this.getParentShell(), false, PluginRegistry.getActiveModels((boolean)true));
        if (dialog.open() == 0) {
            this.text.setText(((IPluginModel)dialog.getFirstResult()).getPlugin().getId());
            this.refreshList();
        }
    }

    protected void computeResult() {
        this.computeIconPath();
        List<Object> proxies = Arrays.asList(this.getSelectedElements());
        ArrayList<String> results = new ArrayList<String>(proxies.size());
        for (Object proxy : proxies) {
            results.add(((ImageProxy)proxy).getPluginPath());
        }
        this.setResult(results);
    }

    protected Object[] getSelectedElements() {
        Assert.isNotNull((Object)this.filteredList);
        return this.filteredList.getSelection();
    }

    protected void createFilterText(Composite parent) {
        final StringWithClearEditor filterText = new StringWithClearEditor(parent, 2048);
        filterText.setValue(this.filter);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                BundleIconExplorerDialog.this.filteredList.setFilter(BundleIconExplorerDialog.ASTERISK + filterText.getValue());
            }
        };
        filterText.getText().addListener(24, listener);
        filterText.getText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (0x1000002 == e.keyCode) {
                    BundleIconExplorerDialog.this.filteredList.setFocus();
                }
            }
        });
    }

    protected FilteredList createFilteredList(Composite parent) {
        int flags = 0xB00 | (this.allowMultiple ? 2 : 4);
        FilteredList list = new FilteredList(parent, flags, (ILabelProvider)new BundleIconLabelProvider(), true, true, true);
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(18);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        list.setLayoutData((Object)data);
        list.setFont(parent.getFont());
        list.setFilter(this.filter == null ? EMPTY : this.filter);
        this.filteredList = list;
        return list;
    }

    public String getCurrentBundleName() {
        return this.currentBundleName;
    }

    private void computeIconPath() {
        List<Object> proxies = Arrays.asList(this.getSelectedElements());
        if (proxies.size() == 1) {
            this.localPath = ((ImageProxy)proxies.get(0)).getLocalPath();
        }
    }

    public String getIconPath() {
        return this.localPath;
    }

    public class BundleIconLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ImageProxy) {
                return ((ImageProxy)element).getImage();
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ImageProxy) {
                return ((ImageProxy)element).getText();
            }
            return super.getText(element);
        }
    }

    protected class ImageProxy {
        private final Image image;
        private String path;
        private String localPath;
        private String fileName;

        public ImageProxy(URL url) {
            this.localPath = url.getPath();
            this.path = BundleIconExplorerDialog.PLUGIN_PROTOCOL + BundleIconExplorerDialog.this.getCurrentBundleName() + this.localPath;
            this.image = Activator.getImageFromKey(this.path);
            int index = this.localPath.lastIndexOf(47);
            this.fileName = index > 0 && index < this.localPath.length() ? this.localPath.substring(index + 1, this.localPath.length() - GIF_EXTENSION_LENGTH) : Messages.BundleIconExplorerDialog_UnknownFileName;
        }

        public boolean isInitial() {
            return BundleIconExplorerDialog.this.initialValue.equals(this.path);
        }

        public Image getImage() {
            return this.image;
        }

        public boolean isDisplayed() {
            Rectangle bounds = this.image.getBounds();
            return bounds.height == 16 && bounds.width == 16;
        }

        public String getText() {
            return this.fileName;
        }

        public String getPluginPath() {
            return this.path;
        }

        public String getLocalPath() {
            return this.localPath;
        }
    }
}

