/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class BlendedBackgroundPainter
extends TextPainter {
    private final RGB gridBackgroundColour;

    public BlendedBackgroundPainter(RGB gridBackgroundColour) {
        this.gridBackgroundColour = gridBackgroundColour;
    }

    @Override
    protected Color getBackgroundColour(ILayerCell cell, IConfigRegistry configRegistry) {
        return BlendedBackgroundPainter.blendBackgroundColour(cell, configRegistry, this.gridBackgroundColour);
    }

    public static Color blendBackgroundColour(ILayerCell cell, IConfigRegistry configRegistry, RGB baseColor) {
        List<Color> colours = CellStyleUtil.getAllBackgroundColors(cell, configRegistry, DisplayMode.NORMAL);
        if (cell.getDisplayMode().equals((Object)DisplayMode.SELECT)) {
            CellStyleProxy cellStyle = new CellStyleProxy(configRegistry, DisplayMode.SELECT, (List<String>)cell.getConfigLabels());
            colours.add(cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        }
        if (colours.isEmpty()) {
            return null;
        }
        if (colours.size() == 1) {
            return colours.get(0);
        }
        RGB rgb = colours.get(0).getRGB();
        int i = 1;
        while (i < colours.size()) {
            if (rgb.equals((Object)baseColor)) {
                rgb = colours.get(i).getRGB();
            } else if (!colours.get(i).getRGB().equals((Object)baseColor)) {
                rgb = GUIHelper.blend(rgb, colours.get(i).getRGB());
            }
            ++i;
        }
        return GUIHelper.getColor(rgb);
    }
}

