/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.datachange;

import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.datachange.CellKeyHandler;
import org.eclipse.nebula.widgets.nattable.datachange.DataChangeLayer;
import org.eclipse.nebula.widgets.nattable.datachange.TemporaryDataProvider;
import org.eclipse.nebula.widgets.nattable.datachange.TemporaryUpdateDataChange;
import org.eclipse.nebula.widgets.nattable.datachange.UpdateDataChangeHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;

public class TemporaryUpdateDataChangeHandler
extends UpdateDataChangeHandler<TemporaryUpdateDataChange>
implements TemporaryDataProvider,
ILayerCommandHandler<UpdateDataCommand> {
    public TemporaryUpdateDataChangeHandler(DataChangeLayer layer, CellKeyHandler<?> keyHandler) {
        super(layer, keyHandler, new ConcurrentHashMap());
    }

    @Override
    public boolean tracksDataChange(int columnPosition, int rowPosition) {
        Object key = this.keyHandler.getKey(columnPosition, rowPosition);
        return key != null && this.dataChanges.containsKey(key);
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        Object key = this.keyHandler.getKey(columnPosition, rowPosition);
        return ((TemporaryUpdateDataChange)this.dataChanges.get(key)).getValue();
    }

    @Override
    public boolean doCommand(ILayer targetLayer, UpdateDataCommand command) {
        if (command.convertToTargetLayer(this.layer)) {
            Object currentValue;
            int rowPosition;
            UpdateDataCommand updateCommand;
            int columnPosition;
            Object key;
            if (this.handleDataUpdate && (key = this.keyHandler.getKey(columnPosition = (updateCommand = command).getColumnPosition(), rowPosition = updateCommand.getRowPosition())) != null && ((currentValue = this.layer.getDataValueByPosition(columnPosition, rowPosition)) == null && updateCommand.getNewValue() != null || updateCommand.getNewValue() == null && currentValue != null || currentValue != null && updateCommand.getNewValue() != null && !currentValue.equals(updateCommand.getNewValue()))) {
                TemporaryUpdateDataChange change = new TemporaryUpdateDataChange(key, command.getNewValue(), this.keyHandler);
                this.layer.addDataChange(change);
                Object underlyingDataValue = this.layer.getUnderlyingLayerByPosition(0, 0).getDataValueByPosition(columnPosition, rowPosition);
                if (updateCommand.getNewValue() == null && underlyingDataValue == null || updateCommand.getNewValue() != null && updateCommand.getNewValue().equals(underlyingDataValue)) {
                    this.dataChanges.remove(key);
                    this.rebuildPositionCollections();
                } else {
                    this.changedColumns.add(columnPosition);
                    this.changedRows.add(rowPosition);
                    this.dataChanges.put(key, change);
                }
                this.layer.fireLayerEvent(new CellVisualChangeEvent(this.layer, columnPosition, rowPosition));
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<UpdateDataCommand> getCommandClass() {
        return UpdateDataCommand.class;
    }
}

