/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public abstract class AbstractPositionCommand
implements ILayerCommand {
    private PositionCoordinate positionCoordinate;

    protected AbstractPositionCommand(ILayer layer, int columnPosition, int rowPosition) {
        this.positionCoordinate = new PositionCoordinate(layer, columnPosition, rowPosition);
    }

    protected AbstractPositionCommand(AbstractPositionCommand command) {
        this.positionCoordinate = command.positionCoordinate;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        PositionCoordinate targetPositionCoordinate = LayerCommandUtil.convertPositionToTargetContext(this.positionCoordinate, targetLayer);
        if (targetPositionCoordinate != null) {
            this.positionCoordinate = targetPositionCoordinate;
            return true;
        }
        return false;
    }

    public ILayer getLayer() {
        return this.positionCoordinate.getLayer();
    }

    public int getColumnPosition() {
        return this.positionCoordinate.getColumnPosition();
    }

    public int getRowPosition() {
        return this.positionCoordinate.getRowPosition();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + this.positionCoordinate.getLayer() + " columnPosition=" + this.positionCoordinate.getColumnPosition() + ", rowPosition=" + this.positionCoordinate.getRowPosition() + "]";
    }
}

