/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.dnd.strategy;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideElementsRequest;

public abstract class GraphicalTransactionalDropStrategy
extends TransactionalDropStrategy {
    protected Command getGraphicalCommand(Request request, EditPart targetEditPart) {
        DropObjectsRequest dropRequest = this.getDropObjectsRequest(request);
        if (dropRequest == null) {
            return null;
        }
        List<CreateViewRequest.ViewDescriptor> viewDescriptors = this.getViewDescriptors(dropRequest, targetEditPart);
        if (viewDescriptors.isEmpty()) {
            return null;
        }
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = targetEditPart.getCommand((Request)createViewRequest);
        if (createCommand != null) {
            List result = (List)createViewRequest.getNewObject();
            dropRequest.setResult((Object)result);
            RefreshConnectionsRequest refreshRequest = new RefreshConnectionsRequest(result);
            Command refreshCommand = targetEditPart.getCommand((Request)refreshRequest);
            ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
            arrangeRequest.setViewAdaptersToArrange(result);
            Command arrangeCommand = targetEditPart.getCommand((Request)arrangeRequest);
            CompoundCommand cc = new CompoundCommand(createCommand.getLabel());
            cc.add(createCommand.chain(refreshCommand));
            cc.add(arrangeCommand);
            for (Object object : dropRequest.getObjects()) {
                ShowHideElementsRequest destroyViewRequest;
                EditPart editPart;
                Command destroyViewCommand;
                if (!(object instanceof EditPart) || (destroyViewCommand = (editPart = (EditPart)object).getCommand((Request)(destroyViewRequest = new ShowHideElementsRequest(editPart)))) == null) continue;
                cc.add(destroyViewCommand);
            }
            return cc;
        }
        return null;
    }

    protected abstract List<CreateViewRequest.ViewDescriptor> getViewDescriptors(DropObjectsRequest var1, EditPart var2);
}

