/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.sequence.locator.CenterLocator;

public class StateInvariantLocator
extends CenterLocator {
    public StateInvariantLocator(IFigure parentFigure, int location) {
        super(parentFigure, location);
    }

    public void relocate(IFigure borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Dimension size = this.getSize(borderItem);
        Point ptNewLocation = new Point(this.getParentBorder().getCenter().x - size.width / 2, constraintLocation.y);
        borderItem.setBounds(new Rectangle(ptNewLocation, size));
    }

    @Override
    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Point point = new Point(this.getParentBorder().getCenter().x - realLocation.getSize().width / 2, realLocation.y);
        realLocation.setLocation(point);
        return realLocation;
    }
}

