/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.CustomSetConnectionAnchorsCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.CustomSetConnectionBendpointsCommand;

public class CustomGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)node.getModel())));
        CustomSetConnectionAnchorsCommand scaCommand = new CustomSetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        scaCommand.setNode(node);
        scaCommand.setSourceReconnectRequest(request);
        scaCommand.setSourceSet(true);
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Source);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        return new ICommandProxy((ICommand)cc);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command cmdRouter;
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP == null) {
            return null;
        }
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        sceCommand.setNewTargetAdaptor((IAdaptable)targetEP);
        CustomSetConnectionAnchorsCommand scaCommand = new CustomSetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        scaCommand.setNode(targetEP);
        scaCommand.setTargetReconnectRequest(request);
        scaCommand.setTargetSet(true);
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Target);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        ICommandProxy cmd = new ICommandProxy((ICommand)cc);
        ConnectionEditPart cep = request.getConnectionEditPart();
        RoutingStyle style = (RoutingStyle)((View)cep.getModel()).getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        Routing currentRouter = Routing.MANUAL_LITERAL;
        if (style != null) {
            currentRouter = style.getRouting();
        }
        if ((cmdRouter = this.getRoutingAdjustment((IAdaptable)request.getConnectionEditPart(), this.getSemanticHint((Request)request), currentRouter, request.getTarget())) != null) {
            cmd = cmd == null ? cmdRouter : cmd.chain(cmdRouter);
            CustomSetConnectionBendpointsCommand csbbCommand = new CustomSetConnectionBendpointsCommand(editingDomain);
            csbbCommand.setNode(node);
            csbbCommand.setEdgeAdaptor((IAdaptable)request.getConnectionEditPart());
            csbbCommand.setRequest(request);
            ICommandProxy cmdBP = new ICommandProxy((ICommand)csbbCommand);
            if (cmdBP != null) {
                cmd = cmd == null ? cmdBP : cmd.chain((Command)cmdBP);
            }
        }
        return cmd;
    }

    private TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected static ReconnectRequest copyReconnectRequest(ReconnectRequest initialRequest) {
        ReconnectRequest reconnectRequest = new ReconnectRequest();
        reconnectRequest.setConnectionEditPart(initialRequest.getConnectionEditPart());
        reconnectRequest.setLocation(initialRequest.getLocation().getCopy());
        reconnectRequest.setType(initialRequest.getType());
        reconnectRequest.setTargetEditPart(initialRequest.getTarget());
        return reconnectRequest;
    }
}

