/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.TriggeredOperations;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.IRollbackStatus;
import org.eclipse.papyrus.infra.core.resource.RollbackStatus;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.gmfdiag.common.messages.Messages;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class RollbackNotificationHistoryListener
implements IOperationHistoryListener {
    public void historyNotification(OperationHistoryEvent event) {
        switch (event.getEventType()) {
            case 7: {
                long now = System.currentTimeMillis();
                IRollbackStatus rollback = RollbackStatus.findRollbackStatus((IStatus)event.getStatus());
                if (rollback == null) {
                    rollback = this.findRollbackStatus(event.getOperation());
                }
                if (rollback == null) break;
                Collection causalObjects = rollback.getCausalObjects();
                List<String> labels = this.getObjectLabels(causalObjects);
                StatusAdapter adapter = new StatusAdapter((IStatus)new Status(rollback.getSeverity(), rollback.getPlugin(), rollback.getCode(), switch (rollback.getCode()) {
                    case 1 -> labels.isEmpty() ? Messages.RollbackNotificationHistoryListener_exception : NLS.bind((String)Messages.RollbackNotificationHistoryListener_exceptionWithCause, labels);
                    case 2 -> labels.isEmpty() ? Messages.RollbackNotificationHistoryListener_readOnly : NLS.bind((String)Messages.RollbackNotificationHistoryListener_readOnlyWithCause, labels);
                    default -> labels.isEmpty() ? Messages.RollbackNotificationHistoryListener_unknown : NLS.bind((String)Messages.RollbackNotificationHistoryListener_unknownWithCause, labels);
                }, rollback.getException()));
                adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.RollbackNotificationHistoryListener_title);
                adapter.setProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY, (Object)now);
                StatusManager.getManager().handle(adapter, 2);
            }
        }
    }

    protected List<String> getObjectLabels(Iterable<?> objects) {
        ArrayList<String> result = new ArrayList<String>();
        EMFLabelProvider labels = null;
        try {
            for (Object next : objects) {
                if (labels == null) {
                    try {
                        LabelProviderService labelService = null;
                        if (next instanceof EObject) {
                            labelService = (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)((EObject)next));
                        } else if (next instanceof Resource) {
                            labelService = (LabelProviderService)ServiceUtilsForResource.getInstance().getService(LabelProviderService.class, (Object)((Resource)next));
                        }
                        if (labelService != null) {
                            labels = labelService.getLabelProvider();
                        }
                    }
                    catch (ServiceException e) {
                        labels = new EMFLabelProvider();
                    }
                }
                if (labels == null) continue;
                result.add(labels.getText(next));
            }
        }
        finally {
            if (labels != null) {
                labels.dispose();
            }
        }
        return result;
    }

    protected IRollbackStatus findRollbackStatus(IUndoableOperation operation) {
        IRollbackStatus result = null;
        if (operation instanceof ICommand) {
            CommandResult commandResult = ((ICommand)operation).getCommandResult();
            if (commandResult != null) {
                result = RollbackStatus.findRollbackStatus((IStatus)commandResult.getStatus());
            }
        } else if (operation instanceof TriggeredOperations) {
            return this.findRollbackStatus(((TriggeredOperations)operation).getTriggeringOperation());
        }
        return result;
    }
}

