/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.runtime;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintFactory;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.catalog.PropertiesURIHandler;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.internal.ui.Activator;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.renderers.SectionRendererService;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.properties.ui.runtime.SectionDiscriminator;
import org.eclipse.papyrus.infra.properties.ui.runtime.TabModel;
import org.eclipse.papyrus.infra.properties.ui.util.EMFURLStreamHandler;
import org.eclipse.papyrus.infra.properties.ui.xwt.PapyrusXWTCore;
import org.eclipse.papyrus.infra.properties.ui.xwt.XWTTabDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.xwt.DefaultLoadingContext;
import org.eclipse.xwt.ILoadingContext;
import org.eclipse.xwt.IXWTLoader;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTLoaderManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class DefaultDisplayEngine
implements DisplayEngine {
    private static ILoadingContext loadingContext = new DefaultLoadingContext(DefaultDisplayEngine.class.getClassLoader());
    private static PapyrusXWTCore papyrusCore = new PapyrusXWTCore();
    private Map<String, XWTTabDescriptor> currentTabs = new HashMap<String, XWTTabDescriptor>();
    private TabModel<DataSource> displayedSections = new TabModel();
    private TabModel<Control> controls = new TabModel();
    private boolean allowDuplicate;
    private Object xmlCache;
    private List<DataSource> dataSourceCache = new ArrayList<DataSource>();
    private HashMap<ConstraintEvaluationKey, Boolean> constraintEvaluationCache = new HashMap();
    private SectionRendererService sectionRendererService;
    private final List<Runnable> toDispose = new ArrayList<Runnable>();

    public DefaultDisplayEngine() {
        this(false);
    }

    public DefaultDisplayEngine(boolean allowDuplicate) {
        this.allowDuplicate = allowDuplicate;
        BundleContext bundleContext = FrameworkUtil.getBundle(DefaultDisplayEngine.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(SectionRendererService.class);
        this.sectionRendererService = (SectionRendererService)bundleContext.getService(serviceReference);
        this.toDispose.add(() -> {
            boolean bl = bundleContext.ungetService(serviceReference);
        });
    }

    @Override
    public List<ITabDescriptor> getTabDescriptors(Set<View> views) {
        LinkedHashMap<String, XWTTabDescriptor> result = new LinkedHashMap<String, XWTTabDescriptor>();
        HashSet<String> selectedSections = new HashSet<String>();
        for (View view : views) {
            for (Section section : view.getSections()) {
                XWTTabDescriptor descriptor;
                if (selectedSections.contains(section.getName())) continue;
                Tab tab = section.getTab();
                if (tab == null) {
                    Activator.log.warn("Null tab for " + String.valueOf(section));
                    continue;
                }
                if (result.containsKey(tab.getId())) {
                    descriptor = (XWTTabDescriptor)((Object)result.get(tab.getId()));
                } else {
                    descriptor = new XWTTabDescriptor(tab, this.sectionRendererService);
                    result.put(tab.getId(), descriptor);
                }
                descriptor.addSection(section, view, this);
                selectedSections.add(section.getName());
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            XWTTabDescriptor existing = this.currentTabs.get(entry.getKey());
            if (existing == null || existing.equals(entry.getValue())) continue;
            this.disposeControls((String)entry.getKey());
        }
        this.currentTabs = result;
        return new ArrayList<ITabDescriptor>(result.values());
    }

    protected void disposeControls(Section section) {
        DataSource dataSource;
        Control control = this.controls.remove(section);
        if (control != null) {
            control.dispose();
        }
        if ((dataSource = this.displayedSections.remove(section)) != null) {
            dataSource.release();
        }
    }

    protected void disposeControls(String tabID) {
        for (Control control : this.controls.remove(tabID)) {
            control.dispose();
        }
        for (DataSource dataSource : this.displayedSections.remove(tabID)) {
            dataSource.release();
        }
    }

    protected void disposeControls() {
        for (String next : new ArrayList<String>(this.controls.tabIDs())) {
            this.disposeControls(next);
        }
    }

    @Override
    public void dispose() {
        this.disposeControls();
        this.toDispose.forEach(Runnable::run);
        this.toDispose.clear();
    }

    public void invalidate() {
        this.xmlCache = null;
    }

    @Override
    public Control createSection(Composite parent, Section section, DataSource source) {
        if (source == null) {
            return null;
        }
        DataSource existing = this.getDataSource(section);
        if (!this.allowDuplicate && existing != null) {
            if (this.isUnloaded(existing) || this.conflictingArity(existing.getSelection(), source.getSelection())) {
                this.disposeControls(section);
            } else {
                existing.setSelection(source.getSelection());
                return null;
            }
        }
        Control control = this.createSection(parent, section, this.loadXWTFile(section), source);
        this.addDataSource(section, source);
        if (control != null) {
            this.addControl(section, control);
        }
        return control;
    }

    protected DataSource getDataSource(Section section) {
        return this.displayedSections.get(section);
    }

    protected boolean isUnloaded(DataSource dataSource) {
        boolean result = false;
        Iterator iter = dataSource.getSelection().iterator();
        while (!result && iter.hasNext()) {
            EObject next = EMFHelper.getEObject(iter.next());
            boolean bl = result = next != null && next.eIsProxy();
        }
        return result;
    }

    protected boolean conflictingArity(IStructuredSelection selection1, IStructuredSelection selection2) {
        return selection1.size() <= 1 ^ selection2.size() <= 1;
    }

    protected DataSource addDataSource(Section section, DataSource dataSource) {
        DataSource result = this.displayedSections.put(section, (DataSource)((Object)dataSource.retain()));
        if (result != null) {
            result.autoRelease();
        }
        return result;
    }

    protected void addControl(final Section section, Control control) {
        this.controls.put(section, control);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DataSource dataSource = DefaultDisplayEngine.this.displayedSections.remove(section);
                if (dataSource != null) {
                    dataSource.release();
                }
                DefaultDisplayEngine.this.controls.remove(section);
            }
        });
    }

    @Override
    public void refreshSection(Composite parent, Section section, DataSource source) {
        if (!this.dataSourceCache.contains((Object)source)) {
            this.dataSourceCache.add(source);
            this.storeConstraintevalutionForSource(section, source);
            this.disposeAndCreateControl(parent, section, source);
        } else {
            ConstraintEvaluationKey constrainstEvaluationKey = new ConstraintEvaluationKey(source, section);
            if (this.constraintEvaluationCache.containsKey(constrainstEvaluationKey)) {
                boolean newValue = this.evaluateConstraintForSection(section, source);
                if (newValue != this.constraintEvaluationCache.get(constrainstEvaluationKey)) {
                    this.disposeAndCreateControl(parent, section, source);
                    this.storeConstraintevalutionForSource(section, source);
                }
            } else {
                this.storeConstraintevalutionForSource(section, source);
                this.disposeAndCreateControl(parent, section, source);
            }
        }
    }

    protected void disposeAndCreateControl(Composite parent, Section section, DataSource source) {
        Control control;
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        control = this.createSection(parent, section, this.loadXWTFile(section), source);
        this.addDataSource(section, source);
        if (control != null) {
            this.addControl(section, control);
        }
    }

    @Override
    public void storeConstraintevalutionForSource(Section section, DataSource source) {
        if (section.getConstraints().size() > 0) {
            boolean value = this.evaluateConstraintForSection(section, source);
            ConstraintEvaluationKey key = new ConstraintEvaluationKey(source, section);
            if (this.constraintEvaluationCache.containsKey(key)) {
                this.constraintEvaluationCache.replace(key, new Boolean(value));
            } else {
                this.constraintEvaluationCache.put(key, new Boolean(value));
            }
        }
    }

    protected boolean evaluateConstraintForSection(Section section, DataSource source) {
        boolean constraintsvalue = false;
        for (ConstraintDescriptor cd : section.getConstraints()) {
            Constraint c = ConstraintFactory.getInstance().createFromModel(cd);
            List selectionList = source.getSelection().toList();
            boolean bl = constraintsvalue = constraintsvalue || c.match((Collection)selectionList);
        }
        return constraintsvalue;
    }

    @Override
    public Control createSection(Composite parent, Section section, URI sectionFile, DataSource source) {
        Control control;
        block10: {
            if (sectionFile == null && (sectionFile = this.loadXWTFile(section)) == null) {
                return null;
            }
            ILoadingContext xwtContext = XWT.getLoadingContext();
            boolean needsRestoreProfile = XWT.applyProfile((Object)((Object)papyrusCore));
            IXWTLoader xwtLoader = XWTLoaderManager.getActive();
            control = null;
            try {
                try {
                    XWT.setLoadingContext((ILoadingContext)loadingContext);
                    ResourceSet rset = section.eResource().getResourceSet();
                    URL url = new URL(null, sectionFile.toString(), new EMFURLStreamHandler(rset.getURIConverter()));
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("XWT.Container", parent);
                    options.put("XWT.DataContext", (Object)source);
                    options.put(IXWTLoader.XML_CACHE_PROPERTY, this.xmlCache != null ? this.xmlCache : Boolean.TRUE);
                    options.put("XWT.DISABLE_USER_CONTROLS", Boolean.TRUE);
                    XWTLoaderManager.setActive((IXWTLoader)xwtLoader, (boolean)true);
                    control = (Control)XWT.loadWithOptions((URL)url, options);
                    this.xmlCache = options.get(IXWTLoader.XML_CACHE_PROPERTY);
                    if (control != null) {
                        control.setLayoutData((Object)new GridData(4, 4, true, true));
                        this.addControl(section, control);
                    }
                }
                catch (Exception ex) {
                    Activator.log.error("Error while loading " + section.getSectionFile(), (Throwable)ex);
                    this.disposeControls(section.getTab().getId());
                    Label label = new Label(parent, 0);
                    label.setText("An error occured in the property view. The file " + section.getSectionFile() + " could not be loaded");
                    if (needsRestoreProfile) {
                        XWT.restoreProfile();
                    }
                    XWT.setLoadingContext((ILoadingContext)xwtContext);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (needsRestoreProfile) {
                    XWT.restoreProfile();
                }
                XWT.setLoadingContext((ILoadingContext)xwtContext);
                throw throwable;
            }
            if (needsRestoreProfile) {
                XWT.restoreProfile();
            }
            XWT.setLoadingContext((ILoadingContext)xwtContext);
        }
        this.layout(parent);
        this.dataSourceCache.add(source);
        this.storeConstraintevalutionForSource(section, source);
        return control;
    }

    private URI loadXWTFile(Section section) {
        EObject tab = section.eContainer();
        Context context = (Context)tab.eContainer();
        if (context.eResource() == null) {
            context = PropertiesRuntime.getConfigurationManager().getContext(context.getName());
            Activator.log.warn("No resource for Context : " + String.valueOf(context) + " ; refreshing the model");
        }
        URI sectionURI = URI.createURI((String)section.getSectionFile());
        URI baseURI = context.eResource().getURI();
        if ("ppe".equals(baseURI.scheme())) {
            PropertiesURIHandler handler = new PropertiesURIHandler();
            baseURI = handler.getConvertedURI(baseURI);
        }
        sectionURI = sectionURI.resolve(baseURI);
        return sectionURI;
    }

    private void layout(Composite parent) {
        parent.getParent().getParent().layout();
        parent.getParent().layout();
        parent.layout();
    }

    @Override
    public void removeSection(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.layout(parent);
    }

    public static Section discriminate(Section section, Object discriminator) {
        if (section == null) {
            throw new IllegalArgumentException("null section");
        }
        if (discriminator == null) {
            throw new IllegalArgumentException("null discriminator");
        }
        if (SectionDiscriminator.isDiscriminated(section)) {
            throw new IllegalArgumentException("section already has a discriminator");
        }
        return SectionDiscriminator.discriminate(section, discriminator);
    }

    public static Object getDiscriminator(Section section) {
        if (section == null) {
            throw new IllegalArgumentException("null section");
        }
        return SectionDiscriminator.getDiscriminator(section);
    }

    public class ConstraintEvaluationKey {
        private DataSource dataSource = null;
        private Section section = null;

        public ConstraintEvaluationKey(DataSource dataSource, Section section) {
            this.dataSource = dataSource;
            this.section = section;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public Section getSection() {
            return this.section;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dataSource == null ? 0 : ((Object)((Object)this.dataSource)).hashCode());
            result = 31 * result + (this.section == null ? 0 : this.section.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstraintEvaluationKey other = (ConstraintEvaluationKey)obj;
            if (this.dataSource == null ? other.dataSource != null : !((Object)((Object)this.dataSource)).equals((Object)other.dataSource)) {
                return false;
            }
            return !(this.section == null ? other.section != null : !this.section.equals(other.section));
        }
    }
}

