/*****************************************************************************
 * Copyright (c) 2019, 2021 CEA LIST, Christian W. Damus, and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *   Christian W. Damus - bugs 569357, 570097
 *
 *****************************************************************************/

package org.eclipse.papyrus.toolsmiths.validation.elementtypes.constants;

import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CommonProblemConstants;

/**
 * The element types plug-in validation constants.
 */
public class ElementTypesPluginValidationConstants {

	/**
	 * The marker type for the validation of element types plugin.
	 */
	public static final String ELEMENTTYPES_PLUGIN_VALIDATION_MARKER_TYPE = "org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic"; //$NON-NLS-1$

	/**
	 * The extension point identifier for element types configurations files.
	 */
	public static final String ELEMENTTYPES_EXTENSION_POINT_IDENTIFIER = "org.eclipse.papyrus.infra.types.core.elementTypeSetConfiguration"; //$NON-NLS-1$

	/** The element types configurations extension point element name. */
	public static final String ELEM_ELEMENT_TYPE_SET = "elementTypeSet"; //$NON-NLS-1$
	/** The element types configurations extension point attribute name for the client context ID. */
	public static final String ATTR_CLIENT_CONTEXT_ID = "clientContextID"; //$NON-NLS-1$
	/** The element types configurations extension point attribute name for the resource path. */
	public static final String ATTR_PATH = "path"; //$NON-NLS-1$
	/** The default client context ID for Papyrus UML. */
	@SuppressWarnings("restriction")
	public static final String PAPYRUS_UML_CLIENT_CONTEXT = org.eclipse.papyrus.infra.services.edit.internal.context.DefaultTypeContext.ID;

	/** Problem IDs for the markers generated by architecture plug-in validation. */
	public static final int PROBLEM_ID_BASE = CommonProblemConstants.MAX_PROBLEM_ID + 0x01;
	public static final int MISSING_ELEMENT_TYPES_CONFIGURATIONS_MODEL_EXTENSION_ID = PROBLEM_ID_BASE + 0x00;
	public static final int MISSING_ELEMENT_TYPES_CONFIGURATIONS_MODEL_CLIENT_CONTEXT_ID = PROBLEM_ID_BASE + 0x01;
	public static final int UNKNOWN_ELEMENT_TYPES_CONFIGURATIONS_MODEL_CLIENT_CONTEXT_ID = PROBLEM_ID_BASE + 0x02;
	public static final int MAX_PROBLEM_ID = PROBLEM_ID_BASE + 0x3f;

}
