/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.palette;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ChildConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.Configuration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.DrawerConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.LeafConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteconfigurationFactory;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.SeparatorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.StackConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ToolConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.util.PaletteconfigurationSwitch;

public class PaletteConfigurationUtils {
    public static Collection<String> getRequiredProfiles(PaletteConfiguration paletteConfiguration) {
        if (paletteConfiguration == null) {
            return Collections.emptyList();
        }
        return paletteConfiguration.getRequiredProfiles();
    }

    public static boolean removeConfiguration(Configuration configuration) {
        return (Boolean)new PaletteconfigurationSwitch<Boolean>(){

            public Boolean caseStackConfiguration(StackConfiguration configuration) {
                return PaletteConfigurationUtils.removeStack(configuration);
            }

            public Boolean caseDrawerConfiguration(DrawerConfiguration configuration) {
                return PaletteConfigurationUtils.removeDrawer(configuration);
            }

            public Boolean caseToolConfiguration(ToolConfiguration configuration) {
                return PaletteConfigurationUtils.removeTool(configuration);
            }

            public Boolean caseSeparatorConfiguration(SeparatorConfiguration configuration) {
                return PaletteConfigurationUtils.removeSeparator(configuration);
            }
        }.doSwitch((EObject)configuration);
    }

    public static boolean removeDrawer(DrawerConfiguration configuration) {
        EObject container = configuration.eContainer();
        if (!(container instanceof PaletteConfiguration)) {
            return false;
        }
        PaletteConfiguration paletteConfiguration = (PaletteConfiguration)container;
        return paletteConfiguration.getDrawerConfigurations().remove((Object)configuration);
    }

    public static boolean removeStack(StackConfiguration configuration) {
        EObject container = configuration.eContainer();
        if (!(container instanceof DrawerConfiguration)) {
            return false;
        }
        DrawerConfiguration drawerConfiguration = (DrawerConfiguration)container;
        return drawerConfiguration.getOwnedConfigurations().remove((Object)configuration);
    }

    public static boolean removeTool(ToolConfiguration configuration) {
        EObject container = configuration.eContainer();
        if (container instanceof DrawerConfiguration) {
            DrawerConfiguration drawerConfiguration = (DrawerConfiguration)container;
            return drawerConfiguration.getOwnedConfigurations().remove((Object)configuration);
        }
        if (container instanceof StackConfiguration) {
            StackConfiguration stackConfiguration = (StackConfiguration)container;
            return stackConfiguration.getOwnedConfigurations().remove((Object)configuration);
        }
        return false;
    }

    public static boolean removeSeparator(SeparatorConfiguration configuration) {
        EObject container = configuration.eContainer();
        if (container instanceof DrawerConfiguration) {
            DrawerConfiguration drawerConfiguration = (DrawerConfiguration)container;
            return drawerConfiguration.getOwnedConfigurations().remove((Object)configuration);
        }
        if (container instanceof StackConfiguration) {
            StackConfiguration stackConfiguration = (StackConfiguration)container;
            return stackConfiguration.getOwnedConfigurations().remove((Object)configuration);
        }
        return false;
    }

    public static SeparatorConfiguration createSeparator(DrawerConfiguration drawerConfiguration) {
        String id = PaletteConfigurationUtils.generateID("Separator");
        SeparatorConfiguration separatorConfiguration = PaletteconfigurationFactory.eINSTANCE.createSeparatorConfiguration();
        separatorConfiguration.setId(id);
        separatorConfiguration.setLabel(id);
        drawerConfiguration.getOwnedConfigurations().add((Object)separatorConfiguration);
        return separatorConfiguration;
    }

    public static SeparatorConfiguration createSeparator(LeafConfiguration leafConfiguration) {
        int i;
        String id = PaletteConfigurationUtils.generateID("Separator");
        SeparatorConfiguration separatorConfiguration = PaletteconfigurationFactory.eINSTANCE.createSeparatorConfiguration();
        separatorConfiguration.setId(id);
        separatorConfiguration.setLabel(id);
        EObject parentContainer = leafConfiguration.eContainer();
        if (parentContainer instanceof DrawerConfiguration) {
            i = ((DrawerConfiguration)parentContainer).getOwnedConfigurations().indexOf((Object)leafConfiguration);
            if (i < 0) {
                throw new RuntimeException("Impossible to find the index of the configuration: " + String.valueOf(leafConfiguration));
            }
        } else {
            throw new RuntimeException("Impossible to create a stack outside a DrawerConfiguration: " + String.valueOf(leafConfiguration));
        }
        ((DrawerConfiguration)parentContainer).getOwnedConfigurations().add(i + 1, (Object)separatorConfiguration);
        return separatorConfiguration;
    }

    public static StackConfiguration createStack(DrawerConfiguration drawerConfiguration) {
        String id = PaletteConfigurationUtils.generateID("Stack");
        StackConfiguration stackConfiguration = PaletteconfigurationFactory.eINSTANCE.createStackConfiguration();
        stackConfiguration.setId(id);
        stackConfiguration.setLabel(id);
        drawerConfiguration.getOwnedConfigurations().add((Object)stackConfiguration);
        return stackConfiguration;
    }

    public static StackConfiguration createStack(LeafConfiguration leafConfiguration) {
        int i;
        String id = PaletteConfigurationUtils.generateID("Stack");
        StackConfiguration stackConfiguration = PaletteconfigurationFactory.eINSTANCE.createStackConfiguration();
        stackConfiguration.setId(id);
        stackConfiguration.setLabel(id);
        EObject parentContainer = leafConfiguration.eContainer();
        if (parentContainer instanceof DrawerConfiguration) {
            i = ((DrawerConfiguration)parentContainer).getOwnedConfigurations().indexOf((Object)leafConfiguration);
            if (i <= 0) {
                throw new RuntimeException("Impossible to find the index of the configuration: " + String.valueOf(leafConfiguration));
            }
        } else {
            throw new RuntimeException("Impossible to create a stack outside a DrawerConfiguration: " + String.valueOf(leafConfiguration));
        }
        ((DrawerConfiguration)parentContainer).getOwnedConfigurations().add(i + 1, (Object)stackConfiguration);
        return stackConfiguration;
    }

    public static void createDrawer(PaletteConfiguration paletteConfiguration) {
        boolean isFound = false;
        Object newName = "";
        int i = 0;
        while (i < 100 && !isFound) {
            isFound = false;
            boolean alreadyExists = false;
            String newLabel = "Drawer_" + i;
            for (DrawerConfiguration configuration : paletteConfiguration.getDrawerConfigurations()) {
                String label = configuration.getLabel();
                if (!newLabel.equalsIgnoreCase(label)) continue;
                alreadyExists = true;
            }
            if (!alreadyExists) {
                isFound = true;
                newName = newLabel;
            }
            ++i;
        }
        DrawerConfiguration drawerConfiguration = PaletteconfigurationFactory.eINSTANCE.createDrawerConfiguration();
        drawerConfiguration.setId(PaletteConfigurationUtils.generateID("Drawer"));
        drawerConfiguration.setLabel((String)newName);
        paletteConfiguration.getDrawerConfigurations().add((Object)drawerConfiguration);
    }

    protected static String generateID(String base) {
        StringBuffer id = new StringBuffer();
        id.append(base);
        id.append("_");
        id.append(System.currentTimeMillis());
        return id.toString();
    }

    public static void moveDrawerConfiguration(PaletteConfiguration paletteConfiguration, DrawerConfiguration drawerConfigurationToMove, DrawerConfiguration drawerConfiguration) {
        int referenceIndex = paletteConfiguration.getDrawerConfigurations().indexOf((Object)drawerConfiguration);
        int indexToMove = paletteConfiguration.getDrawerConfigurations().indexOf((Object)drawerConfigurationToMove);
        if (referenceIndex == -1) {
            Activator.log.error("Impossible to find the drawer before which the drawer to move should be placed", null);
            return;
        }
        if (indexToMove == -1) {
            Activator.log.error("Impossible to find the drawer to move", null);
            return;
        }
        if (referenceIndex == indexToMove) {
            return;
        }
        if (referenceIndex < indexToMove) {
            paletteConfiguration.getDrawerConfigurations().remove((Object)drawerConfigurationToMove);
            paletteConfiguration.getDrawerConfigurations().add(referenceIndex, (Object)drawerConfigurationToMove);
        } else {
            paletteConfiguration.getDrawerConfigurations().remove((Object)drawerConfigurationToMove);
            paletteConfiguration.getDrawerConfigurations().add(referenceIndex - 1, (Object)drawerConfigurationToMove);
        }
    }

    public static void moveSeparatorConfiguration(DrawerConfiguration drawerConfiguration, SeparatorConfiguration separatorConfigurationToMove) {
        DrawerConfiguration oldContainer = (DrawerConfiguration)separatorConfigurationToMove.eContainer();
        if (oldContainer.equals(drawerConfiguration)) {
            drawerConfiguration.getOwnedConfigurations().remove((Object)separatorConfigurationToMove);
        }
        drawerConfiguration.getOwnedConfigurations().add((Object)separatorConfigurationToMove);
    }

    public static void moveSeparatorConfiguration(ChildConfiguration childConfiguration, SeparatorConfiguration separatorConfigurationToMove) {
        DrawerConfiguration parentConfiguration = (DrawerConfiguration)childConfiguration.eContainer();
        Configuration oldContainer = (Configuration)separatorConfigurationToMove.eContainer();
        int index = parentConfiguration.getOwnedConfigurations().indexOf((Object)childConfiguration);
        if (index == -1) {
            Activator.log.error("Impossible to find the child configuration:" + String.valueOf(childConfiguration), null);
            return;
        }
        if (oldContainer.equals(parentConfiguration)) {
            parentConfiguration.getOwnedConfigurations().remove((Object)separatorConfigurationToMove);
        }
        parentConfiguration.getOwnedConfigurations().add(index, (Object)separatorConfigurationToMove);
    }

    public static void moveStackConfiguration(DrawerConfiguration drawerConfiguration, StackConfiguration stackConfigurationToMove) {
        DrawerConfiguration oldContainer = (DrawerConfiguration)stackConfigurationToMove.eContainer();
        if (oldContainer.equals(drawerConfiguration)) {
            drawerConfiguration.getOwnedConfigurations().remove((Object)stackConfigurationToMove);
        }
        drawerConfiguration.getOwnedConfigurations().add((Object)stackConfigurationToMove);
    }

    public static void moveStackConfiguration(ChildConfiguration childConfiguration, StackConfiguration stackConfigurationToMove) {
        DrawerConfiguration parentConfiguration = (DrawerConfiguration)childConfiguration.eContainer();
        Configuration oldContainer = (Configuration)stackConfigurationToMove.eContainer();
        int index = parentConfiguration.getOwnedConfigurations().indexOf((Object)childConfiguration);
        if (index == -1) {
            Activator.log.error("Impossible to find the child configuration:" + String.valueOf(childConfiguration), null);
            return;
        }
        if (oldContainer.equals(parentConfiguration)) {
            parentConfiguration.getOwnedConfigurations().remove((Object)stackConfigurationToMove);
        }
        parentConfiguration.getOwnedConfigurations().add(index, (Object)stackConfigurationToMove);
    }

    public static void moveToolConfiguration(DrawerConfiguration drawerConfiguration, ToolConfiguration toolConfigurationToMove) {
        Configuration oldContainer = (Configuration)toolConfigurationToMove.eContainer();
        if (oldContainer.equals(drawerConfiguration)) {
            drawerConfiguration.getOwnedConfigurations().remove((Object)toolConfigurationToMove);
        }
        drawerConfiguration.getOwnedConfigurations().add((Object)toolConfigurationToMove);
    }

    public static void moveToolConfiguration(ChildConfiguration childConfiguration, ToolConfiguration toolConfigurationToMove) {
        EObject parentConfiguration = childConfiguration.eContainer();
        Configuration oldContainer = (Configuration)toolConfigurationToMove.eContainer();
        if (parentConfiguration instanceof DrawerConfiguration) {
            int index = ((DrawerConfiguration)parentConfiguration).getOwnedConfigurations().indexOf((Object)childConfiguration);
            if (index == -1) {
                Activator.log.error("Impossible to find the child configuration:" + String.valueOf(childConfiguration), null);
                return;
            }
            if (oldContainer.equals(parentConfiguration)) {
                ((DrawerConfiguration)parentConfiguration).getOwnedConfigurations().remove((Object)toolConfigurationToMove);
            }
            ((DrawerConfiguration)parentConfiguration).getOwnedConfigurations().add(index, (Object)toolConfigurationToMove);
        } else if (parentConfiguration instanceof StackConfiguration) {
            int index = ((StackConfiguration)parentConfiguration).getOwnedConfigurations().indexOf((Object)childConfiguration);
            if (index == -1) {
                Activator.log.error("Impossible to find the child configuration:" + String.valueOf(childConfiguration), null);
                return;
            }
            if (oldContainer.equals(parentConfiguration)) {
                ((StackConfiguration)parentConfiguration).getOwnedConfigurations().remove((Object)toolConfigurationToMove);
            }
            ((StackConfiguration)parentConfiguration).getOwnedConfigurations().add(index, (Object)toolConfigurationToMove);
        } else {
            Activator.log.error("Not handled yet: parent of the tool is:" + String.valueOf(parentConfiguration), null);
        }
    }

    public static void moveToolConfiguration(StackConfiguration stackConfiguration, ToolConfiguration toolConfigurationToMove) {
        EObject oldContainer = toolConfigurationToMove.eContainer();
        if (oldContainer.equals(stackConfiguration)) {
            stackConfiguration.getOwnedConfigurations().remove((Object)toolConfigurationToMove);
        }
        stackConfiguration.getOwnedConfigurations().add((Object)toolConfigurationToMove);
    }
}

