/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.IPinUpdater;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.InvocationAction;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.StructuredActivityNode;

public abstract class AbstractInvocationActionPinUpdater<NodeType extends InvocationAction>
implements IPinUpdater<NodeType> {
    protected static final String TARGET_NAME = "target";

    protected <P extends Pin> void update(List<P> originPins, List<P> newPins) {
        ArrayList<Pin> orderedPinsList = new ArrayList<Pin>();
        for (Pin newPin : newPins) {
            Iterator<P> originPinsIterator = originPins.iterator();
            Pin preservedPin = null;
            while (originPinsIterator.hasNext() && preservedPin == null) {
                Pin originPin = (Pin)originPinsIterator.next();
                if (orderedPinsList.contains(originPin) || !AbstractInvocationActionPinUpdater.isReusable(newPin, originPin)) continue;
                preservedPin = originPin;
                AbstractInvocationActionPinUpdater.update(preservedPin, newPin);
                orderedPinsList.add(preservedPin);
            }
            if (preservedPin != null) continue;
            orderedPinsList.add(newPin);
        }
        for (Pin pin : originPins) {
            if (orderedPinsList.contains(pin)) continue;
            AbstractInvocationActionPinUpdater.delete(pin);
        }
        originPins.clear();
        originPins.addAll(orderedPinsList);
    }

    private static boolean isReusable(Pin new_, Pin origin) {
        boolean reuse = true;
        if (new_.getType() != null && origin.getType() != null) {
            reuse = origin.getType().conformsTo(new_.getType());
        }
        if (reuse) {
            reuse = origin.compatibleWith((MultiplicityElement)new_);
        }
        return reuse;
    }

    protected static void update(Pin origin, Pin new_) {
        origin.setLower(new_.getLower());
        origin.setUpper(new_.getUpper());
        origin.setType(new_.getType());
        origin.setName(new_.getName());
    }

    protected static void delete(Pin pin) {
        ArrayList edgeToDelete = new ArrayList(pin.getIncomings());
        edgeToDelete.addAll(pin.getOutgoings());
        for (ActivityEdge edge : edgeToDelete) {
            Element owner = edge.getOwner();
            if (owner == null) continue;
            if (owner instanceof StructuredActivityNode) {
                ((StructuredActivityNode)owner).getEdges().remove((Object)edge);
                continue;
            }
            if (owner instanceof Activity) {
                ((Activity)owner).getEdges().remove((Object)edge);
                continue;
            }
            if (!(owner instanceof ActivityPartition)) continue;
            ((ActivityPartition)owner).getEdges().remove((Object)edge);
        }
    }

    @Override
    public void updatePins(NodeType node) {
        this.update((List)node.getArguments(), (List)this.deriveArguments(node));
    }

    public abstract List<InputPin> deriveArguments(NodeType var1);

    public InputPin deriveTarget(NodeType node) {
        return null;
    }
}

