/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.messages.Messages;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProfileCustomValidator
extends CustomModelChecker.SwitchValidator {
    public ProfileCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(Package package_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.validatePackageURI(package_.getURI(), (EObject)package_, diagnostics, context);
    }

    public void validateDefault(EObject stereotypeApplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClass stereotype = stereotypeApplication.eClass();
        if (this.isEPackageStereotype(stereotype)) {
            String uri = (String)stereotypeApplication.eGet(stereotype.getEStructuralFeature(EcorePackage.Literals.EPACKAGE__NS_URI.getName()));
            Element basePackage = UMLUtil.getBaseElement((EObject)stereotypeApplication);
            if (basePackage != null && !basePackage.eIsProxy()) {
                this.validatePackageURI(uri, (EObject)basePackage, diagnostics, context);
            }
        }
    }

    private boolean isEPackageStereotype(EClass eClass) {
        return eClass.getEPackage() != null && EcorePackage.Literals.EPACKAGE.getName().equals(eClass.getName()) && "http://www.eclipse.org/uml2/schemas/Ecore/5".equals(eClass.getEPackage().getNsURI());
    }

    private void validatePackageURI(String uri, EObject target, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (uri != null && !uri.isBlank()) {
            try {
                URI parsed = URI.createURI((String)uri, (boolean)true);
                if (parsed.isRelative()) {
                    diagnostics.add(this.createDiagnostic(4, target, this.format(Messages.ProfileCustomValidator_0, context, new Object[]{target, uri})));
                }
            }
            catch (Exception e) {
                diagnostics.add(this.createDiagnostic(4, target, this.format(Messages.ProfileCustomValidator_1, context, new Object[]{target, uri})));
            }
        }
    }
}

