/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import com.google.common.collect.Queues;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import org.eclipse.papyrus.junit.utils.Activator;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ExecutorRule
extends TestWatcher
implements Executor {
    private final BlockingQueue<Runnable> queue = Queues.newLinkedBlockingQueue();

    @Override
    public void execute(Runnable command) {
        this.queue.add(command);
    }

    protected void runPending() {
        Runnable next = (Runnable)this.queue.poll();
        while (next != null) {
            try {
                next.run();
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in test shutdown runnable.", (Throwable)e);
            }
            next = (Runnable)this.queue.poll();
        }
    }

    protected void finished(Description description) {
        this.runPending();
    }
}

