/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.resources;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.junit.utils.rules.AbstractHouseKeeperRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class WorkspaceModificationAssertion
implements IResourceChangeListener {
    private final IWorkspace ws = ResourcesPlugin.getWorkspace();
    private final Set<URI> requireChange = Sets.newHashSet();
    private final Set<URI> requireNoChange = Sets.newHashSet();
    private final Set<URI> changed = Sets.newHashSet();
    private CoreException exception;

    public WorkspaceModificationAssertion(AbstractHouseKeeperRule houseKeeper) {
        this.ws.addResourceChangeListener((IResourceChangeListener)this);
        houseKeeper.cleanUpLater(this);
    }

    public void dispose() {
        this.ws.removeResourceChangeListener((IResourceChangeListener)this);
        this.reset();
    }

    public void requireChange(URI uri) {
        MatcherAssert.assertThat((String)("conflicting change requirement for " + String.valueOf(uri)), this.requireNoChange, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)uri)));
        this.requireChange.add(uri);
    }

    public void requireNoChange(URI uri) {
        MatcherAssert.assertThat((String)("conflicting change requirement for " + String.valueOf(uri)), this.requireChange, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)uri)));
        this.requireNoChange.add(uri);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource().getType() == 1) {
                        WorkspaceModificationAssertion.this.changed.add(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true));
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.exception = e;
        }
    }

    public void reset() {
        this.requireChange.clear();
        this.requireNoChange.clear();
        this.changed.clear();
        this.exception = null;
    }

    public void save(final ModelSet modelSet) {
        try {
            try {
                this.ws.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            modelSet.save(monitor);
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.junit.utils", "Save failed.", (Throwable)e));
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
                this.exception = e;
            }
            MatcherAssert.assertThat((String)"Resource(s) saved that should not have been", (Object)Sets.intersection(this.requireNoChange, this.changed), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.anything())));
            MatcherAssert.assertThat((String)"Resource(s) not saved that should have been", (Object)Sets.difference(this.requireChange, this.changed), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.anything())));
            MatcherAssert.assertThat((String)"Save assertion failed with an exception", (Object)((Object)this.exception), (Matcher)CoreMatchers.nullValue());
        }
        finally {
            this.reset();
        }
    }
}

