/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.ValueSpecification;

public class MultiplicityElementUtil {
    private static final String QUOTE = "\"";
    private static final Collection<String> DEFAULT_MULTIPLICITY = Collections.unmodifiableCollection(Arrays.asList("[1]", "1"));

    @Deprecated
    public static String getMultiplicityAsString(MultiplicityElement element) {
        return MultiplicityElementUtil.getMultiplicityAsString(element, false);
    }

    @Deprecated
    public static String getMultiplicityAsString(MultiplicityElement element, boolean isEdition) {
        String multiplicity = MultiplicityElementUtil.formatMultiplicity(element, isEdition);
        return multiplicity == null || multiplicity.isEmpty() ? "" : " " + multiplicity;
    }

    public static String formatMultiplicity(MultiplicityElement element) {
        return MultiplicityElementUtil.formatMultiplicity(element, false);
    }

    public static String formatMultiplicity(MultiplicityElement element, boolean isEdition) {
        String multiplicityStr = MultiplicityElementUtil.formatMultiplicityNoBrackets(element, isEdition);
        if (multiplicityStr == null || multiplicityStr.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(multiplicityStr);
        buffer.append("]");
        return buffer.toString();
    }

    public static String formatMultiplicityNoBrackets(MultiplicityElement element) {
        return MultiplicityElementUtil.formatMultiplicityNoBrackets(element, false);
    }

    public static String formatMultiplicityNoBrackets(MultiplicityElement element, boolean isEdition) {
        ValueSpecification lowerSpecification = element.getLowerValue();
        ValueSpecification upperSpecification = element.getUpperValue();
        if (lowerSpecification == null && upperSpecification == null) {
            return MultiplicityElementUtil.setupMultiplicityAsInteger(element.getLower(), element.getUpper());
        }
        if (lowerSpecification == null && upperSpecification instanceof LiteralUnlimitedNatural) {
            return MultiplicityElementUtil.setupMultiplicityAsInteger(element.getLower(), ((LiteralUnlimitedNatural)upperSpecification).unlimitedValue());
        }
        if (lowerSpecification instanceof LiteralInteger && upperSpecification == null) {
            return MultiplicityElementUtil.setupMultiplicityAsInteger(((LiteralInteger)lowerSpecification).integerValue(), element.getUpper());
        }
        if (lowerSpecification instanceof LiteralInteger && upperSpecification instanceof LiteralUnlimitedNatural) {
            return MultiplicityElementUtil.setupMultiplicityAsInteger(((LiteralInteger)lowerSpecification).integerValue(), ((LiteralUnlimitedNatural)upperSpecification).unlimitedValue());
        }
        return MultiplicityElementUtil.setupMultiplicityAsString(element, lowerSpecification, upperSpecification, isEdition);
    }

    private static String setupMultiplicityAsInteger(int lower, int upper) {
        if (lower == upper) {
            return new Integer(lower).toString();
        }
        if (lower == 0 && upper == -1) {
            return "*";
        }
        if (upper == -1) {
            return lower + "..*";
        }
        return lower + ".." + upper;
    }

    private static String setupMultiplicityAsString(MultiplicityElement element, ValueSpecification lower, ValueSpecification upper, boolean isEdition) {
        String lowerStr = MultiplicityElementUtil.getStringSpecificationValue(lower, isEdition);
        if ("*".equals(lowerStr)) {
            return "";
        }
        String upperStr = MultiplicityElementUtil.getStringSpecificationValue(upper, isEdition);
        if (lowerStr != null && !lowerStr.isEmpty() && lowerStr.equalsIgnoreCase(upperStr)) {
            return lowerStr;
        }
        StringBuffer result = new StringBuffer();
        result.append(lowerStr == null || lowerStr.isEmpty() ? Integer.valueOf(element.getLower()) : lowerStr);
        result.append("..");
        result.append(upperStr == null || upperStr.isEmpty() ? MultiplicityElementUtil.getUpper(element) : upperStr);
        return result.toString();
    }

    private static String getUpper(MultiplicityElement element) {
        return element.getUpper() == -1 ? "" : new Integer(element.getUpper()).toString();
    }

    public static int[] parseMultiplicity(String value) throws NumberFormatException {
        int lower = 0;
        int upper = 0;
        int firstIndex = value.indexOf("..");
        if (firstIndex == -1) {
            if ("*".equals(value)) {
                lower = 0;
                upper = -1;
            } else {
                upper = lower = Integer.parseInt(value);
            }
        } else {
            String lowerValue = value.substring(0, firstIndex);
            String upperValue = value.substring(firstIndex + "..".length());
            lower = Integer.parseInt(lowerValue);
            upper = -2;
            upper = "*".equals(upperValue) ? -1 : Integer.parseInt(upperValue);
        }
        return new int[]{lower, upper};
    }

    private static String getStringSpecificationValue(ValueSpecification valueSpecification, boolean isEdition) {
        String boundStr = ValueSpecificationUtil.getSpecificationValue(valueSpecification, true);
        if (isEdition && valueSpecification instanceof LiteralString) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(QUOTE);
            buffer.append(boundStr);
            buffer.append(QUOTE);
            boundStr = buffer.toString();
        }
        return boundStr;
    }

    public static String manageDefaultMultiplicity(String multiplicity, boolean blockDefault) {
        return blockDefault && DEFAULT_MULTIPLICITY.contains(multiplicity) ? "" : multiplicity;
    }
}

