/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.validation;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.emf.helpers.BundleResourceURIHelper;
import org.eclipse.papyrus.emf.helpers.ProjectDependencyHelper;
import org.eclipse.papyrus.emf.validation.DependencyValidationUtils;

public abstract class AbstractEObjectDependencyValidator
extends EObjectValidator {
    protected static final BundleResourceURIHelper RESOURCE_URI_HELPER = BundleResourceURIHelper.INSTANCE;
    protected static final ProjectDependencyHelper PROJECT_DEPENDENCY_HELPER = ProjectDependencyHelper.INSTANCE;
    private EValidator delegate;

    public AbstractEObjectDependencyValidator() {
        this((EValidator)null);
    }

    public AbstractEObjectDependencyValidator(EValidator delegate) {
        this.delegate = delegate;
    }

    public AbstractEObjectDependencyValidator(EPackage ePackage) {
        this(EValidator.Registry.INSTANCE.getEValidator(ePackage));
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.delegate == null) {
            return super.validate(eClass, eObject, diagnostics, context);
        }
        boolean result = this.delegate.validate(eClass, eObject, diagnostics, context);
        if ((result || diagnostics != null) && !eObject.eIsProxy() && eClass.eContainer() == this.getEPackage()) {
            result = this.validate(eClass.getClassifierID(), eObject, diagnostics, context) && result;
        }
        return result;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.delegate == null) {
            return super.validate(eDataType, value, diagnostics, context);
        }
        boolean result = this.delegate.validate(eDataType, value, diagnostics, context);
        if ((result || diagnostics != null) && eDataType.isInstance(value) && eDataType.eContainer() == this.getEPackage()) {
            result = this.validate(eDataType.getClassifierID(), value, diagnostics, context) && result;
        }
        return result;
    }

    public boolean validate_EveryDefaultConstraint(EObject object, DiagnosticChain theDiagnostics, Map<Object, Object> context) {
        return this.delegate != null || super.validate_EveryDefaultConstraint(object, theDiagnostics, context);
    }

    protected final Diagnostic createMissingDependenciesDiagnostic(EObject eobjectInError, EStructuralFeature feature, Collection<String> missingDependencies) {
        return DependencyValidationUtils.createMissingDependenciesDiagnostic(eobjectInError, feature, missingDependencies);
    }
}

