/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.part;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.sequence.expressions.UMLOCLFactory;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public String getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public String getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(String visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(String visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static String getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLSequenceDiagram".equals(view.getType())) {
                return "Package_SequenceDiagram";
            }
            return "";
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static String getVisualID(String type) {
        return type;
    }

    public static String getType(String visualID) {
        return visualID;
    }

    public static String getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        return "Package_SequenceDiagram";
    }

    public static String getNodeVisualID(View containerView, EObject domainElement) {
        block59: {
            String containerVisualID;
            if (domainElement == null) {
                return "";
            }
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"PapyrusUMLSequenceDiagram".equals(containerModelID)) {
                return "";
            }
            if ("PapyrusUMLSequenceDiagram".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_SequenceDiagram";
            } else {
                return "";
            }
            if (containerVisualID == null) break block59;
            switch (containerVisualID) {
                case "Package_SequenceDiagram": {
                    if (!UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) break;
                    return "Interaction_Shape";
                }
                case "Interaction_Shape": {
                    if (!UMLPackage.eINSTANCE.getGate().isSuperTypeOf(domainElement.eClass())) break;
                    return "Gate_Shape";
                }
                case "CombinedFragment_Shape": {
                    if (!UMLPackage.eINSTANCE.getGate().isSuperTypeOf(domainElement.eClass())) break;
                    return "Gate_Shape";
                }
                case "InteractionOperand_Shape": {
                    if (UMLPackage.eINSTANCE.getInteractionUse().isSuperTypeOf(domainElement.eClass())) {
                        return "InteractionUse_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getConsiderIgnoreFragment().isSuperTypeOf(domainElement.eClass())) {
                        return "ConsiderIgnoreFragment_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) {
                        return "CombinedFragment_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getContinuation().isSuperTypeOf(domainElement.eClass())) break;
                    return "Continuation_Shape";
                }
                case "InteractionUse_Shape": {
                    if (!UMLPackage.eINSTANCE.getGate().isSuperTypeOf(domainElement.eClass())) break;
                    return "Gate_Shape";
                }
                case "Lifeline_Shape": {
                    if (UMLPackage.eINSTANCE.getActionExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                        return "ActionExecutionSpecification_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getBehaviorExecutionSpecification().isSuperTypeOf(domainElement.eClass())) {
                        return "BehaviorExecutionSpecification_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                        return "StateInvariant_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getDestructionOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                        return "DestructionOccurrenceSpecification_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "TimeConstraint_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) break;
                    return "TimeObservation_Shape";
                }
                case "ActionExecutionSpecification_Shape": {
                    if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "TimeConstraint_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) break;
                    return "TimeObservation_Shape";
                }
                case "BehaviorExecutionSpecification_Shape": {
                    if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "TimeConstraint_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) break;
                    return "TimeObservation_Shape";
                }
                case "DestructionOccurrenceSpecification_Shape": {
                    if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "TimeConstraint_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) break;
                    return "TimeObservation_Shape";
                }
                case "Interaction_SubfragmentCompartment": {
                    if (UMLPackage.eINSTANCE.getConsiderIgnoreFragment().isSuperTypeOf(domainElement.eClass())) {
                        return "ConsiderIgnoreFragment_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getCombinedFragment().isSuperTypeOf(domainElement.eClass())) {
                        return "CombinedFragment_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass())) {
                        return "Lifeline_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getInteractionUse().isSuperTypeOf(domainElement.eClass())) {
                        return "InteractionUse_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape";
                    }
                    if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                    return "Comment_Shape";
                }
                case "CombinedFragment_SubfragmentCompartment": {
                    if (!UMLPackage.eINSTANCE.getInteractionOperand().isSuperTypeOf(domainElement.eClass())) break;
                    return "InteractionOperand_Shape";
                }
            }
        }
        return "";
    }

    public static boolean canCreateNode(View containerView, String nodeVisualID) {
        block131: {
            String containerVisualID;
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"PapyrusUMLSequenceDiagram".equals(containerModelID)) {
                return false;
            }
            if ("PapyrusUMLSequenceDiagram".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_SequenceDiagram";
            } else {
                return false;
            }
            if (containerVisualID == null) break block131;
            switch (containerVisualID) {
                case "Package_SequenceDiagram": {
                    if (!"Interaction_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interaction_Shape": {
                    if ("Interaction_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Interaction_SubfragmentCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Gate_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "CombinedFragment_Shape": {
                    if ("CombinedFragment_SubfragmentCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Gate_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "InteractionOperand_Shape": {
                    if ("InteractionUse_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("ConsiderIgnoreFragment_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("CombinedFragment_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Continuation_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "InteractionUse_Shape": {
                    if ("InteractionUse_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("InteractionUse_TypeLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Gate_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Continuation_Shape": {
                    if (!"Continuation_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Lifeline_Shape": {
                    if ("Lifeline_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("ActionExecutionSpecification_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("BehaviorExecutionSpecification_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("StateInvariant_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DestructionOccurrenceSpecification_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("TimeConstraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"TimeObservation_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "ActionExecutionSpecification_Shape": {
                    if ("TimeConstraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"TimeObservation_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "BehaviorExecutionSpecification_Shape": {
                    if ("TimeConstraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"TimeObservation_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "StateInvariant_Shape": {
                    if ("StateInvariant_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"StateInvariant_ConstraintLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DestructionOccurrenceSpecification_Shape": {
                    if ("TimeConstraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"TimeObservation_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_Shape": {
                    if ("Constraint_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Comment_Shape": {
                    if (!"Comment_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Gate_Shape": {
                    if (!"Gate_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "TimeConstraint_Shape": {
                    if ("TimeConstraint_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"TimeConstraint_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "TimeObservation_Shape": {
                    if ("TimeObservation_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"TimeObservation_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interaction_SubfragmentCompartment": {
                    if ("ConsiderIgnoreFragment_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("CombinedFragment_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Lifeline_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("InteractionUse_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Comment_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "CombinedFragment_SubfragmentCompartment": {
                    if (!"InteractionOperand_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_SynchEdge": {
                    if ("Message_SynchNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_SynchStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_AsynchEdge": {
                    if ("Message_AsynchNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_AsynchStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_ReplyEdge": {
                    if ("Message_ReplyNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_ReplyStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_CreateEdge": {
                    if ("Message_CreateNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_CreateStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_DeleteEdge": {
                    if ("Message_DeleteNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_DeleteStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_LostEdge": {
                    if ("Message_LostNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_LostStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Message_FoundEdge": {
                    if ("Message_FoundNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Message_FoundStereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "GeneralOrdering_Edge": {
                    if (!"GeneralOrdering_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_ContextEdge": {
                    if (!"Constraint_KeywordLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DurationConstraint_Edge": {
                    if ("DurationConstraint_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"DurationConstraint_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DurationObservation_Edge": {
                    if ("DurationObservation_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"DurationObservation_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_SynchEdge((Message)domainElement)) {
            return "Message_SynchEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_AsynchEdge((Message)domainElement)) {
            return "Message_AsynchEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_ReplyEdge((Message)domainElement)) {
            return "Message_ReplyEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_CreateEdge((Message)domainElement)) {
            return "Message_CreateEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_DeleteEdge((Message)domainElement)) {
            return "Message_DeleteEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_LostEdge((Message)domainElement)) {
            return "Message_LostEdge";
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_FoundEdge((Message)domainElement)) {
            return "Message_FoundEdge";
        }
        if (UMLPackage.eINSTANCE.getGeneralOrdering().isSuperTypeOf(domainElement.eClass())) {
            return "GeneralOrdering_Edge";
        }
        if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
            return "DurationConstraint_Edge";
        }
        if (UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) {
            return "DurationObservation_Edge";
        }
        return "";
    }

    private static boolean isMessage_SynchEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(1, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_AsynchEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(4, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_ReplyEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(7, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_CreateEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(10, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_DeleteEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(13, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_LostEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(16, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_FoundEdge(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(19, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
        if (candidate == null) {
            return false;
        }
        String basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return candidate.equals(basic);
    }

    public static boolean isCompartmentVisualID(String visualID) {
        block9: {
            if (visualID == null) break block9;
            switch (visualID) {
                case "CombinedFragment_SubfragmentCompartment": 
                case "Interaction_SubfragmentCompartment": {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(String visualID) {
        block24: {
            if (visualID == null) break block24;
            switch (visualID) {
                case "Package_SequenceDiagram": {
                    return false;
                }
                case "Gate_Shape": 
                case "Constraint_Shape": 
                case "ConsiderIgnoreFragment_Shape": 
                case "StateInvariant_Shape": 
                case "Comment_Shape": 
                case "Continuation_Shape": 
                case "TimeObservation_Shape": 
                case "TimeConstraint_Shape": {
                    return true;
                }
            }
        }
        return false;
    }
}

