/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.ReconnectMessageHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class ExecutionOccurrenceSpecificationMessageReorientCommand
extends EditElementCommand {
    private final EObject oldEnd;
    private final EObject newEnd;

    public ExecutionOccurrenceSpecificationMessageReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        Message link = this.getLink();
        if (link == null) {
            return false;
        }
        MessageSort messageSort = link.getMessageSort();
        return MessageSort.SYNCH_CALL_LITERAL == messageSort || MessageSort.ASYNCH_CALL_LITERAL == messageSort || MessageSort.REPLY_LITERAL == messageSort;
    }

    protected Message getLink() {
        return (Message)this.getRequest().getRelationship();
    }

    protected ReorientRelationshipRequest getRequest() {
        return (ReorientRelationshipRequest)super.getRequest();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        int direction = this.getRequest().getDirection();
        if (1 == direction) {
            return this.reorientSource();
        }
        if (2 == direction) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected Element getOldSource() {
        return (Element)this.oldEnd;
    }

    protected Element getNewSource() {
        return (Element)this.newEnd;
    }

    protected Element getOldTarget() {
        return (Element)this.oldEnd;
    }

    protected Element getNewTarget() {
        return (Element)this.newEnd;
    }

    protected ExecutionSpecification getExecution(Element element, boolean isSource) {
        if (element instanceof ExecutionSpecification) {
            return (ExecutionSpecification)element;
        }
        if (element instanceof OccurrenceSpecification) {
            return OccurrenceSpecificationHelper.findExecutionWith((OccurrenceSpecification)element, isSource);
        }
        return null;
    }

    protected CommandResult reorientTarget() {
        MessageEnd receiveEvent = this.getLink().getReceiveEvent();
        if (receiveEvent != null && receiveEvent == this.getNewTarget()) {
            return CommandResult.newOKCommandResult();
        }
        ExecutionSpecification oldExecution = this.getExecution(this.getOldTarget(), false);
        ExecutionSpecification newExecution = this.getExecution(this.getNewTarget(), false);
        ReconnectMessageHelper.updateMessageEnd(receiveEvent, (Element)oldExecution, (Element)newExecution);
        ReconnectMessageHelper.updateMessage(this.getLink());
        if (oldExecution != null && receiveEvent != null) {
            if (receiveEvent == oldExecution.getStart()) {
                OccurrenceSpecificationHelper.resetExecutionStart(oldExecution, (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
            } else if (receiveEvent == oldExecution.getFinish()) {
                OccurrenceSpecificationHelper.resetExecutionFinish(oldExecution, (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
            }
        }
        if (newExecution != null && receiveEvent instanceof MessageOccurrenceSpecification) {
            if (this.getNewTarget() == newExecution.getStart()) {
                OccurrenceSpecificationHelper.resetExecutionStart(newExecution, (Element)receiveEvent);
            } else if (this.getNewTarget() == newExecution.getFinish()) {
                OccurrenceSpecificationHelper.resetExecutionFinish(newExecution, (Element)receiveEvent);
            }
        }
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientSource() {
        MessageEnd sendEvent = this.getLink().getSendEvent();
        if (sendEvent != null && sendEvent == this.getNewTarget()) {
            return CommandResult.newOKCommandResult();
        }
        ExecutionSpecification oldExecution = this.getExecution(this.getOldTarget(), false);
        ExecutionSpecification newExecution = this.getExecution(this.getNewTarget(), false);
        ReconnectMessageHelper.updateMessageEnd(sendEvent, (Element)oldExecution, (Element)newExecution);
        if (oldExecution != null && sendEvent instanceof MessageOccurrenceSpecification) {
            if (sendEvent == oldExecution.getStart()) {
                OccurrenceSpecificationHelper.resetExecutionStart(oldExecution, (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
            } else if (sendEvent == oldExecution.getFinish()) {
                OccurrenceSpecificationHelper.resetExecutionFinish(oldExecution, (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
            }
        }
        if (newExecution != null && sendEvent instanceof MessageOccurrenceSpecification) {
            if (this.getNewTarget() == newExecution.getStart()) {
                OccurrenceSpecificationHelper.resetExecutionStart(newExecution, (Element)sendEvent);
            } else if (this.getNewTarget() == newExecution.getFinish()) {
                OccurrenceSpecificationHelper.resetExecutionFinish(newExecution, (Element)sendEvent);
            }
        }
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }
}

