/**
 * Copyright (c) 2007, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Dmitry Stadnik (Borland) - rewritten in xpand
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InitDiagramAction;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;

@Singleton
@SuppressWarnings("all")
public class InitDiagramFileAction {
  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;

  @Inject
  private Externalizer xptExternalizer;

  @Inject
  private DiagramEditorUtil xptDiagramEditorUtil;

  @Inject
  private Activator xptActivator;

  @Inject
  private NewDiagramFileWizard xptNewDiagramFileWizard;

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _lastSegment = this._common_qvto.lastSegment(it.getInitDiagramFileActionQualifiedClassName());
    _builder.append(_lastSegment);
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _withoutLastSegment = this._common_qvto.withoutLastSegment(it.getInitDiagramFileActionQualifiedClassName());
    _builder.append(_withoutLastSegment);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence InitDiagramFileAction(final InitDiagramAction it, final GenEditorGenerator editorGen) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _InitDiagramFileAction = this.InitDiagramFileAction(editorGen, it.getQualifiedClassName());
    _builder.append(_InitDiagramFileAction);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * HACK to deal with the InitDiagramAction instance being constructed at codegen time, * and Ant being capable of supplying (existing!) target object only
   */
  public CharSequence Hack(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _InitDiagramFileAction = this.InitDiagramFileAction(it, it.getDiagram().getInitDiagramFileActionQualifiedClassName());
    _builder.append(_InitDiagramFileAction);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence implementsList(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenApplication _application = it.getApplication();
      boolean _tripleEquals = (_application == null);
      if (_tripleEquals) {
        CharSequence _implementsList_PDE = this.implementsList_PDE(it);
        _builder.append(_implementsList_PDE);
      } else {
        CharSequence _implementsList_RCP = this.implementsList_RCP(it);
        _builder.append(_implementsList_RCP);
      }
    }
    return _builder;
  }

  public CharSequence implementsList_PDE(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.ui.IObjectActionDelegate");
    return _builder;
  }

  public CharSequence implementsList_RCP(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.ui.IWorkbenchWindowActionDelegate");
    return _builder;
  }

  public CharSequence InitDiagramFileAction(final GenEditorGenerator editorGen, final String qualifiedClassName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(editorGen);
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(editorGen.getDiagram());
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(editorGen.getDiagram());
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(editorGen);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application = editorGen.getApplication();
      boolean _tripleEquals = (_application == null);
      if (_tripleEquals) {
        _builder.newLine();
        _builder.append("\t");
        CharSequence _classBody_PDE = this.classBody_PDE(editorGen.getDiagram());
        _builder.append(_classBody_PDE, "\t");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t");
        CharSequence _classBody_RCP = this.classBody_RCP(editorGen.getDiagram());
        _builder.append(_classBody_RCP, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence classBody_RCP(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.ui.IWorkbenchWindow window;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public void init(org.eclipse.ui.IWorkbenchWindow window) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.window = window;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("public void dispose() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("window = null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public void selectionChanged(org.eclipse.jface.action.IAction action, org.eclipse.jface.viewers.ISelection selection) {");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.swt.widgets.Shell getShell() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return window.getShell();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI_1 = this._codeStyle.overrideI(it);
    _builder.append(_overrideI_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public void run(org.eclipse.jface.action.IAction action) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory.INSTANCE.createEditingDomain();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource resource =");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName, "\t\t\t");
    _builder.append(".openModel(getShell(), ");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForInitDiagramOpenFileDialogTitle());
    _builder.append(_accessorCall, "\t\t\t");
    _builder.append(", editingDomain);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (resource == null || resource.getContents().isEmpty()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject diagramRoot = (org.eclipse.emf.ecore.EObject) resource.getContents().get(0);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.jface.wizard.Wizard wizard = new ");
    CharSequence _qualifiedClassName_1 = this.xptNewDiagramFileWizard.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append("(resource.getURI(), diagramRoot, editingDomain);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("wizard.setWindowTitle(org.eclipse.osgi.util.NLS.bind(");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForInitDiagramFileWizardTitle());
    _builder.append(_accessorCall_1, "\t");
    _builder.append(", ");
    CharSequence _modelID = VisualIDRegistry.modelID(it.getEditorGen().getDiagram());
    _builder.append(_modelID, "\t");
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _qualifiedClassName_2 = this.xptDiagramEditorUtil.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_2, "\t");
    _builder.append(".runWizard(getShell(), wizard, \"InitDiagramFile\"); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence classBody_PDE(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.ui.IWorkbenchPart targetPart;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.emf.common.util.URI domainModelURI;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public void setActivePart(org.eclipse.jface.action.IAction action, org.eclipse.ui.IWorkbenchPart targetPart) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.targetPart = targetPart;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI_1 = this._codeStyle.overrideI(it);
    _builder.append(_overrideI_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public void selectionChanged(org.eclipse.jface.action.IAction action, org.eclipse.jface.viewers.ISelection selection) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("domainModelURI = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("action.setEnabled(false);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (selection instanceof org.eclipse.jface.viewers.IStructuredSelection == false || selection.isEmpty()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.core.resources.IFile file =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("(org.eclipse.core.resources.IFile) ((org.eclipse.jface.viewers.IStructuredSelection) selection).getFirstElement();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("domainModelURI = org.eclipse.emf.common.util.URI.createPlatformResourceURI(file.getFullPath().toString(), true);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("action.setEnabled(true);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.swt.widgets.Shell getShell() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return targetPart.getSite().getShell();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI_2 = this._codeStyle.overrideI(it);
    _builder.append(_overrideI_2);
    _builder.newLineIfNotEmpty();
    _builder.append("public void run(org.eclipse.jface.action.IAction action) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.workspace.WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();");
    _builder.newLine();
    {
      boolean _isSameFileForDiagramAndModel = it.getEditorGen().isSameFileForDiagramAndModel();
      if (_isSameFileForDiagramAndModel) {
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.resource.ResourceSet resourceSet = new org.eclipse.emf.ecore.resource.impl.ResourceSetImpl();");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.resource.ResourceSet resourceSet = editingDomain.getResourceSet();");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject diagramRoot = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource resource = resourceSet.getResource(domainModelURI, true);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("diagramRoot = resource.getContents().get(0);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (org.eclipse.emf.common.util.WrappedException ex) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getInstance().logError(\"Unable to load resource: \" + domainModelURI, ex); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (diagramRoot == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.dialogs.MessageDialog.openError(getShell(), ");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForInitDiagramFileResourceErrorDialog()));
    _builder.append(_accessorCall, "\t\t");
    _builder.append(", ");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.messageKey(this.i18nKeyForInitDiagramFileResourceErrorDialog()));
    _builder.append(_accessorCall_1, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.jface.wizard.Wizard wizard = new ");
    String _newDiagramFileWizardQualifiedClassName = it.getEditorGen().getDiagram().getNewDiagramFileWizardQualifiedClassName();
    _builder.append(_newDiagramFileWizardQualifiedClassName, "\t");
    _builder.append("(domainModelURI, diagramRoot, editingDomain);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("wizard.setWindowTitle(org.eclipse.osgi.util.NLS.bind(");
    CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForInitDiagramFileWizardTitle());
    _builder.append(_accessorCall_2, "\t");
    _builder.append(", ");
    CharSequence _modelID = VisualIDRegistry.modelID(it.getEditorGen().getDiagram());
    _builder.append(_modelID, "\t");
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_1, "\t");
    _builder.append(".runWizard(getShell(), wizard, \"InitDiagramFile\"); ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence i18nAccessors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForInitDiagramFileResourceErrorDialog()));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForInitDiagramFileResourceErrorDialog()));
    _builder.append(_accessorField_1);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_2 = this.xptExternalizer.accessorField(this.i18nKeyForInitDiagramFileWizardTitle());
    _builder.append(_accessorField_2);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_3 = this.xptExternalizer.accessorField(this.i18nKeyForInitDiagramOpenFileDialogTitle());
    _builder.append(_accessorField_3);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForInitDiagramFileResourceErrorDialog()), "Error");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForInitDiagramFileResourceErrorDialog()), "Model file loading failed");
    _builder.append(_messageEntry_1);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(this.i18nKeyForInitDiagramFileWizardTitle(), "Initialize new {0} diagram file");
    _builder.append(_messageEntry_2);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(this.i18nKeyForInitDiagramOpenFileDialogTitle(), "Select domain model");
    _builder.append(_messageEntry_3);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public String i18nKeyForInitDiagramFileResourceErrorDialog() {
    return "InitDiagramFile.ResourceErrorDialog";
  }

  @Localization
  public String i18nKeyForInitDiagramFileWizardTitle() {
    return "InitDiagramFile.WizardTitle";
  }

  @Localization
  public String i18nKeyForInitDiagramOpenFileDialogTitle() {
    return "InitDiagramFile.OpenModelFileDialogTitle";
  }
}
