/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.strategy.paste.ShowConstraintContextLink;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CreateViewCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomCompositeStateSetBoundsCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomCompositeStateWithDefaultRegionCreateNodeCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomFirstRegionInCompositeStateCreateElementCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomRegionCreateElementCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomRegionMoveCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomStateMachineSetBoundsCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomStateMachineWithDefaultRegionCreateNodeCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomRegionEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.RegionFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.StateMachineLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.policies.CustomRegionDragTracker;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateMachineCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.ConnectionPointReference;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class CustomStateMachineDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    IFigure sizeOnDropFeedback = null;
    String dropLocation = "R";
    boolean fromOutline = false;

    public CustomStateMachineDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)StateMachineLinkMappingHelper.getInstance());
    }

    protected Command dropAffixedNode(DropObjectsRequest dropRequest, Element droppedElement, String nodeVISUALID) {
        Pseudostate ps;
        PseudostateKind kind;
        if (!(droppedElement instanceof Pseudostate) && !(droppedElement instanceof ConnectionPointReference)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (droppedElement instanceof Pseudostate && !(kind = (ps = (Pseudostate)droppedElement).getKind()).equals((Object)PseudostateKind.ENTRY_POINT_LITERAL) && !kind.equals((Object)PseudostateKind.EXIT_POINT_LITERAL)) {
            return UnexecutableCommand.INSTANCE;
        }
        Boolean isCompartmentTarget = false;
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        Point dropLocation = dropRequest.getLocation().getCopy();
        if (graphicalParentEditPart instanceof RegionCompartmentEditPart) {
            isCompartmentTarget = true;
            RegionFigure regionFigure = ((RegionEditPart)graphicalParentEditPart.getParent()).getPrimaryShape();
            graphicalParentEditPart = (GraphicalEditPart)graphicalParentEditPart.getParent().getParent().getParent();
        } else if (graphicalParentEditPart instanceof StateCompartmentEditPart) {
            isCompartmentTarget = true;
            graphicalParentEditPart = (GraphicalEditPart)graphicalParentEditPart.getParent();
        }
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof StateMachine && ((StateMachine)graphicalParentObject).getConnectionPoints().contains((Object)droppedElement)) {
            if (isCompartmentTarget.booleanValue()) {
                return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
            }
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
        }
        if (graphicalParentObject instanceof State) {
            EList connectionPoints;
            State state = (State)graphicalParentObject;
            State redefinedState = state.getRedefinedState();
            if (redefinedState != null) {
                connectionPoints = new BasicEList((Collection)state.getConnectionPoints());
                connectionPoints.addAll((Collection)redefinedState.getConnectionPoints());
            } else {
                connectionPoints = state.getConnectionPoints();
            }
            if (droppedElement instanceof Pseudostate && connectionPoints.contains((Object)droppedElement) || droppedElement instanceof ConnectionPointReference && ((State)graphicalParentObject).getConnections().contains((Object)droppedElement)) {
                if (isCompartmentTarget.booleanValue()) {
                    return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
                }
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropPseudostate(DropObjectsRequest dropRequest, Element droppedElement, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        EObject droppedElemContainer = droppedElement.eContainer();
        Region extendedRegion = null;
        if (graphicalParentObject instanceof Region) {
            extendedRegion = ((Region)graphicalParentObject).getExtendedRegion();
        }
        if (graphicalParentObject instanceof Region && (droppedElemContainer == graphicalParentObject || droppedElemContainer == extendedRegion)) {
            Point location = this.getTranslatedLocation(dropRequest);
            CompositeCommand cc = new CompositeCommand("Drop pseudo state");
            if (graphicalParentEditPart.getParent() instanceof RegionEditPart) {
                RegionFigure regionFigure = ((RegionEditPart)graphicalParentEditPart.getParent()).getPrimaryShape();
                regionFigure.translateToAbsolute((Translatable)location);
                location.translate(regionFigure.getLocation());
            }
            cc.compose((IUndoableOperation)this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement, dropRequest));
            return new ICommandProxy(cc.reduce());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropRegion(DropObjectsRequest dropRequest, Region droppedElement, String nodeVISUALID) {
        State state;
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof Region) {
            Region region = (Region)graphicalParentObject;
            if (region.getStateMachine() != null && region.getStateMachine().getRegions().contains((Object)droppedElement) && !region.equals(droppedElement) || region.getState() != null && region.getState().getRegions().contains((Object)droppedElement) && !region.equals(droppedElement)) {
                CompositeCommand cc = new CompositeCommand("Drop");
                SemanticAdapter adaptableForDroppedRegion = new SemanticAdapter((EObject)droppedElement, null);
                View existingRegionView = (View)graphicalParentEditPart.getParent().getModel();
                SemanticAdapter adaptableForExistingRegionView = new SemanticAdapter(null, (Object)existingRegionView);
                View compartment = (View)existingRegionView.eContainer();
                View alreadyShown = null;
                Iterator it = compartment.getChildren().iterator();
                while (alreadyShown == null && it.hasNext()) {
                    View current = (View)it.next();
                    if (!current.getElement().equals(droppedElement)) continue;
                    alreadyShown = current;
                }
                if (alreadyShown != null) {
                    if (this.fromOutline) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    SemanticAdapter adaptableForRegionToMove = new SemanticAdapter(null, alreadyShown);
                    CustomRegionMoveCommand moveCommand = new CustomRegionMoveCommand((IAdaptable)adaptableForExistingRegionView, (IAdaptable)adaptableForRegionToMove, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), this.getEditingDomain(), DiagramUIMessages.CreateCommand_Label, this.dropLocation);
                    cc.compose((IUndoableOperation)moveCommand);
                } else {
                    CustomRegionCreateElementCommand createNewRegion = new CustomRegionCreateElementCommand((IAdaptable)adaptableForExistingRegionView, (IAdaptable)adaptableForDroppedRegion, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), this.getEditingDomain(), DiagramUIMessages.CreateCommand_Label, this.dropLocation);
                    cc.compose((IUndoableOperation)createNewRegion);
                }
                return new ICommandProxy(cc.reduce());
            }
        } else if (graphicalParentObject instanceof State && (state = (State)graphicalParentObject).getRegions().contains((Object)droppedElement)) {
            View stateView = (View)graphicalParentEditPart.getModel();
            if (stateView.getChildren().size() < 2) {
                return UnexecutableCommand.INSTANCE;
            }
            View compartment = ViewUtil.getChildBySemanticHint((View)stateView, (String)String.valueOf("State_RegionCompartment"));
            if (!compartment.getChildren().isEmpty()) {
                return UnexecutableCommand.INSTANCE;
            }
            CompositeCommand cc = new CompositeCommand("Drop");
            SemanticAdapter adaptableForDroppedRegion = new SemanticAdapter((EObject)droppedElement, null);
            SemanticAdapter adaptableForCompartment = new SemanticAdapter(null, (Object)compartment);
            CustomFirstRegionInCompositeStateCreateElementCommand createNewRegion = new CustomFirstRegionInCompositeStateCreateElementCommand((IAdaptable)adaptableForCompartment, (IAdaptable)adaptableForDroppedRegion, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), this.getEditingDomain(), DiagramUIMessages.CreateCommand_Label, this.dropLocation);
            SetPropertyCommand showCompartment = new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)adaptableForCompartment, "notation.View.visible", "Visibility", (Object)true);
            cc.compose((IUndoableOperation)createNewRegion);
            cc.compose((IUndoableOperation)showCompartment);
            return new ICommandProxy(cc.reduce());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropStateMachine(DropObjectsRequest dropRequest, Point location, StateMachine droppedElement, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof StateMachine) {
            CompositeCommand cc = new CompositeCommand("Drop");
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)droppedElement);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
            CreateCommand createStateMachine = new CreateCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getModel());
            CustomStateMachineWithDefaultRegionCreateNodeCommand createRegion = new CustomStateMachineWithDefaultRegionCreateNodeCommand((IAdaptable)createStateMachine.getCommandResult().getReturnValue(), ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), this.getEditingDomain(), DiagramUIMessages.CreateCommand_Label, createStateMachine.getAffectedFiles());
            CustomStateMachineSetBoundsCommand setBoundsCommand = new CustomStateMachineSetBoundsCommand(this.getEditingDomain(), null, descriptor, new Rectangle(location.x, location.y, -1, -1));
            cc.compose((IUndoableOperation)createStateMachine);
            cc.compose((IUndoableOperation)createRegion);
            cc.compose((IUndoableOperation)setBoundsCommand);
            return new ICommandProxy(cc.reduce());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropStateEditPartTN(DropObjectsRequest dropRequest, Point location, State semanticElement, String nodeVISUALID) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropState(DropObjectsRequest dropRequest, Point location, State droppedElement, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        EObject droppedElemContainer = droppedElement.eContainer();
        Region extendedRegion = null;
        if (graphicalParentObject instanceof Region) {
            extendedRegion = ((Region)graphicalParentObject).getExtendedRegion();
        }
        if (graphicalParentObject instanceof Region && (droppedElemContainer == graphicalParentObject || droppedElemContainer == extendedRegion)) {
            CompositeCommand cc = new CompositeCommand("Drop");
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)droppedElement);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
            CreateCommand createState = new CreateCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getModel());
            CustomCompositeStateWithDefaultRegionCreateNodeCommand createRegion = new CustomCompositeStateWithDefaultRegionCreateNodeCommand((IAdaptable)createState.getCommandResult().getReturnValue(), ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), this.getEditingDomain(), DiagramUIMessages.CreateCommand_Label, createState.getAffectedFiles());
            cc.compose((IUndoableOperation)createState);
            cc.compose((IUndoableOperation)createRegion);
            Rectangle parentBounds = graphicalParentEditPart.getFigure().getBounds().getCopy();
            graphicalParentEditPart.getFigure().translateToAbsolute((Translatable)parentBounds);
            Point relLocation = new Point(location.x - parentBounds.x, location.y - parentBounds.y);
            if (droppedElement.getRegions().isEmpty()) {
                int sizeHint = droppedElement instanceof FinalState ? 20 : 60;
                CustomCompositeStateSetBoundsCommand setBoundsCommand = new CustomCompositeStateSetBoundsCommand(this.getEditingDomain(), null, descriptor, new Rectangle(relLocation.x, relLocation.y, sizeHint, sizeHint), false);
                cc.compose((IUndoableOperation)setBoundsCommand);
            } else {
                CustomCompositeStateSetBoundsCommand setBoundsCommand = new CustomCompositeStateSetBoundsCommand(this.getEditingDomain(), null, descriptor, new Rectangle(relLocation.x, relLocation.y, -1, -1), true);
                cc.compose((IUndoableOperation)setBoundsCommand);
                SetPropertyCommand showCompartment = new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)createState.getCommandResult().getReturnValue(), "notation.View.visible", "Visibility", true){

                    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        ENamedElement namedElement;
                        View view = (View)this.getViewAdapter().getAdapter(View.class);
                        if (view != null && view.getChildren().size() >= 2 && view.getChildren().get(1) != null && (namedElement = PackageUtil.getElement((String)((String)this.getPropertyId()))) instanceof EStructuralFeature) {
                            ViewUtil.setStructuralFeatureValue((View)((View)view.getChildren().get(1)), (EStructuralFeature)((EStructuralFeature)namedElement), (Object)this.getNewValue());
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                cc.compose((IUndoableOperation)showCompartment);
            }
            return new ICommandProxy(cc.reduce());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropTransition(DropObjectsRequest dropRequest, Transition droppedElement, String linkVISUALID) {
        EList transitions;
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (droppedElement.getKind().getValue() == 0) {
            return this.dropInternalTransition(dropRequest, droppedElement, this.getNodeVisualID(graphicalParentEditPart.getNotationView(), (EObject)droppedElement));
        }
        if (!(graphicalParentObject instanceof Region)) {
            return UnexecutableCommand.INSTANCE;
        }
        Region region = (Region)graphicalParentObject;
        Object extendedRegion = region.getExtendedRegion();
        if (extendedRegion != null) {
            transitions = new BasicEList((Collection)region.getTransitions());
            transitions.addAll((Collection)extendedRegion.getTransitions());
        } else {
            transitions = region.getTransitions();
        }
        if (!transitions.contains((Object)droppedElement)) {
            return UnexecutableCommand.INSTANCE;
        }
        Vertex source = droppedElement.getSource();
        Vertex target = droppedElement.getTarget();
        if (source != null && target != null) {
            GraphicalEditPart sourceEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)source);
            GraphicalEditPart targetEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)target);
            DiagramEditPart diagram = DiagramEditPartsUtil.getDiagramEditPart((EditPart)this.getHost());
            IGraphicalEditPart sourceParent = null;
            IGraphicalEditPart targetParent = null;
            if (sourceEditPart == null || targetEditPart == null) {
                List allEPs = DiagramEditPartsUtil.getAllEditParts((EditPart)diagram);
                EObject srcParent = source.eContainer();
                EObject tgtParent = target.eContainer();
                if (srcParent instanceof Region) {
                    extendedRegion = ((Region)graphicalParentObject).getExtendedRegion();
                }
                for (IGraphicalEditPart iGraphicalEditPart : allEPs) {
                    EObject object = ViewUtil.resolveSemanticElement((View)((View)iGraphicalEditPart.getModel()));
                    extendedRegion = object instanceof Region ? ((Region)object).getExtendedRegion() : null;
                    if (!(object != srcParent && extendedRegion != srcParent || iGraphicalEditPart instanceof CompartmentEditPart)) {
                        sourceParent = iGraphicalEditPart;
                    }
                    if (!(object != tgtParent && extendedRegion != tgtParent || iGraphicalEditPart instanceof CompartmentEditPart)) {
                        targetParent = iGraphicalEditPart;
                    }
                    if (targetParent == null || sourceParent == null) continue;
                    sourceParent = (EditPart)sourceParent.getChildren().get(0);
                    targetParent = (EditPart)targetParent.getChildren().get(0);
                    break;
                }
                if (targetParent == null || sourceParent == null) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Transition"), (Element)source, (Element)target, linkVISUALID, dropRequest.getLocation(), (Element)droppedElement, (EditPart)sourceParent, (EditPart)targetParent));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropInternalTransition(DropObjectsRequest dropRequest, Transition droppedElement, String nodeVisualID) {
        if (nodeVisualID != null) {
            CompositeCommand cc = new CompositeCommand("Drop Internal Transition");
            ICommand defaultDropNodeCommand = this.getDefaultDropNodeCommand(nodeVisualID, dropRequest.getLocation().getCopy(), (EObject)droppedElement, dropRequest);
            cc.compose((IUndoableOperation)defaultDropNodeCommand);
            if (cc != null) {
                cc.reduce();
                if (!cc.isEmpty() && cc.canExecute()) {
                    GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
                    IGraphicalEditPart compartmentEP = graphicalParentEditPart.getChildBySemanticHint(String.valueOf("State_RegionCompartment"));
                    if (compartmentEP != null) {
                        SemanticAdapter adaptableForCompartment = new SemanticAdapter(null, compartmentEP.getModel());
                        SetPropertyCommand showCompartment = new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)adaptableForCompartment, "notation.View.visible", "Visibility", (Object)true);
                        cc.compose((IUndoableOperation)showCompartment);
                    }
                    return new ICommandProxy((ICommand)cc);
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    public CompositeCommand dropBinaryLink(CompositeCommand cc, Element source, Element target, String linkVISUALID, Point location, Element semanticLink, EditPart sourceParent, EditPart targetParent) {
        SetBoundsCommand setBoundsCommand;
        CreateCommand nodeCreationCommand;
        CreateViewRequest.ViewDescriptor descriptor;
        GraphicalEditPart sourceEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)source);
        GraphicalEditPart targetEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)target);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getUMLElementType(linkVISUALID), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        if (sourceEditPart == null) {
            descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)source), Node.class, null, -1, true, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)sourceParent.getModel());
            cc.compose((IUndoableOperation)nodeCreationCommand);
            setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y + 30));
            cc.compose((IUndoableOperation)setBoundsCommand);
            sourceAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (target != null && !target.equals(source)) {
            if (targetEditPart == null) {
                descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)target), Node.class, null, -1, true, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
                nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)targetParent.getModel());
                cc.compose((IUndoableOperation)nodeCreationCommand);
                setBoundsCommand = !targetParent.equals(sourceParent) ? new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(10, 10)) : new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y - 30));
                cc.compose((IUndoableOperation)setBoundsCommand);
                targetAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
            } else {
                targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
            }
        }
        if (target != null && target.equals(source)) {
            targetAdapter = sourceAdapter;
        }
        CommonDeferredCreateConnectionViewCommand aLinkCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        cc.compose((IUndoableOperation)aLinkCommand);
        return cc;
    }

    public void eraseTargetFeedback(Request request) {
        if (this.sizeOnDropFeedback != null) {
            this.removeFeedback(this.sizeOnDropFeedback);
            this.sizeOnDropFeedback = null;
        }
    }

    protected CompoundCommand getDropAffixedNodeInCompartmentCommand(String nodeVISUALID, Point location, EObject droppedObject) {
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
        CreateViewCommand createCommand = null;
        if (nodeVISUALID != "ConnectionPointReference_Shape") {
            createCommand = new CreateViewCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getParent().getParent().getParent().getModel());
            cc.add((Command)new ICommandProxy((ICommand)createCommand));
        } else {
            createCommand = new CreateViewCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getParent().getModel());
            cc.add((Command)new ICommandProxy((ICommand)createCommand));
        }
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), location);
        cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        return cc;
    }

    protected Set<String> getDroppableElementVisualId() {
        HashSet<String> droppableElementsVisualId = new HashSet<String>();
        droppableElementsVisualId.add("StateMachine_Shape");
        droppableElementsVisualId.add("State_Shape_TN");
        droppableElementsVisualId.add("State_Shape");
        droppableElementsVisualId.add("Region_Shape");
        droppableElementsVisualId.add("Pseudostate_EntryPointShape");
        droppableElementsVisualId.add("Pseudostate_ExitPointShape");
        droppableElementsVisualId.add("ConnectionPointReference_Shape");
        droppableElementsVisualId.add("Transition_Edge");
        droppableElementsVisualId.add("Pseudostate_InitialShape");
        droppableElementsVisualId.add("Pseudostate_TerminateShape");
        droppableElementsVisualId.add("Pseudostate_ChoiceShape");
        droppableElementsVisualId.add("Pseudostate_DeepHistoryShape");
        droppableElementsVisualId.add("Pseudostate_ShallowHistoryShape");
        droppableElementsVisualId.add("Pseudostate_ForkShape");
        droppableElementsVisualId.add("Pseudostate_JoinShape");
        droppableElementsVisualId.add("Pseudostate_JunctionShape");
        droppableElementsVisualId.add("FinalState_Shape");
        droppableElementsVisualId.add("Constraint_Shape");
        return droppableElementsVisualId;
    }

    public String getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public String getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement instanceof Region && containerView.getElement() instanceof Region) {
            return "Region_Shape";
        }
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    protected IFigure getSizeOnDropFeedback() {
        if (this.sizeOnDropFeedback == null) {
            this.sizeOnDropFeedback = new RectangleFigure();
            FigureUtilities.makeGhostShape((Shape)((Shape)this.sizeOnDropFeedback));
            ((Shape)this.sizeOnDropFeedback).setLineStyle(4);
            this.sizeOnDropFeedback.setForegroundColor(ColorConstants.white);
            this.addFeedback(this.sizeOnDropFeedback);
        }
        return this.sizeOnDropFeedback;
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        block54: {
            Point location;
            block52: {
                location = dropRequest.getLocation().getCopy();
                if (linkVISUALID == null) break block52;
                switch (linkVISUALID) {
                    case "Transition_Edge": {
                        return this.dropTransition(dropRequest, (Transition)semanticElement, linkVISUALID);
                    }
                }
            }
            if (nodeVISUALID == null) break block54;
            switch (nodeVISUALID) {
                case "StateMachine_Shape": {
                    return this.dropStateMachine(dropRequest, location, (StateMachine)semanticElement, nodeVISUALID);
                }
                case "State_Shape_TN": {
                    return this.dropStateEditPartTN(dropRequest, location, (State)semanticElement, nodeVISUALID);
                }
                case "State_Shape": 
                case "FinalState_Shape": {
                    return this.dropState(dropRequest, location, (State)semanticElement, nodeVISUALID);
                }
                case "Region_Shape": {
                    return this.dropRegion(dropRequest, (Region)semanticElement, nodeVISUALID);
                }
                case "ConnectionPointReference_Shape": 
                case "Pseudostate_ExitPointShape": 
                case "Pseudostate_EntryPointShape": {
                    return this.dropAffixedNode(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Pseudostate_ShallowHistoryShape": 
                case "Pseudostate_JunctionShape": 
                case "Pseudostate_JoinShape": 
                case "Pseudostate_DeepHistoryShape": 
                case "Pseudostate_TerminateShape": 
                case "Pseudostate_ChoiceShape": 
                case "Pseudostate_ForkShape": 
                case "Pseudostate_InitialShape": {
                    return this.dropPseudostate(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Constraint_Shape": {
                    return this.dropConstraint(dropRequest, (Constraint)semanticElement, nodeVISUALID);
                }
            }
        }
        return super.getSpecificDropCommand(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
    }

    protected Command dropConstraint(DropObjectsRequest dropRequest, Constraint constraint, String nodeVISUALID) {
        ICommand dropConstraintCommand = this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)constraint, dropRequest);
        if (constraint.getContext() != null) {
            ShowConstraintContextLink showConstraintContextLink = new ShowConstraintContextLink(this.getEditingDomain(), (GraphicalEditPart)this.getHost(), constraint);
            dropConstraintCommand = dropConstraintCommand.compose((IUndoableOperation)showConstraintContextLink);
        }
        return GMFtoGEFCommandWrapper.wrap((ICommand)dropConstraintCommand);
    }

    public IElementType getUMLElementType(String elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public void showTargetFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest && !"resize".equals(request.getType())) {
            this.fromOutline = false;
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            for (EObject element : changeBoundsRequest.getEditParts()) {
                if (!(element instanceof RegionEditPart)) continue;
                CustomRegionEditPart regionEditPart = (CustomRegionEditPart)element;
                View compartment = (View)((View)element.getModel()).eContainer();
                if (compartment.getChildren().size() == 1) {
                    return;
                }
                CustomRegionDragTracker dragTracker = regionEditPart.getRegionDragTracker();
                RegionEditPart targetEP = dragTracker.getTargetRegionEditPart();
                if (targetEP == null) continue;
                RegionFigure targetFig = targetEP.getPrimaryShape();
                Rectangle targetFigBounds = targetFig.getBounds().getCopy();
                targetFig.translateToAbsolute((Translatable)targetFigBounds);
                Point mouseLocation = changeBoundsRequest.getLocation();
                this.dropLocation = Zone.getZoneFromLocationInRectangleWithAbsoluteCoordinates(mouseLocation, targetFigBounds);
                if (Zone.isTop(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
                } else if (Zone.isLeft(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
                } else if (Zone.isRight(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
                    targetFigBounds.translate(targetFigBounds.width, 0);
                } else if (Zone.isBottom(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
                    targetFigBounds.translate(0, targetFigBounds.height);
                }
                this.getSizeOnDropFeedback().setBounds((Rectangle)new PrecisionRectangle(targetFigBounds));
            }
        }
        if (request instanceof DropObjectsRequest) {
            this.fromOutline = true;
            DropObjectsRequest dropRequest = (DropObjectsRequest)request;
            for (EObject element : dropRequest.getObjects()) {
                if (!(element instanceof Region) || !(this.getHost().getParent() instanceof RegionEditPart)) continue;
                View compartment = null;
                if (this.getHost().getParent().getParent() instanceof StateMachineCompartmentEditPart) {
                    compartment = (View)((StateMachineCompartmentEditPart)this.getHost().getParent().getParent()).getModel();
                } else if (this.getHost().getParent().getParent() instanceof StateCompartmentEditPart) {
                    compartment = (View)((StateCompartmentEditPart)this.getHost().getParent().getParent()).getModel();
                }
                View alreadyShown = null;
                if (compartment == null) continue;
                Iterator it = compartment.getChildren().iterator();
                while (alreadyShown == null && it.hasNext()) {
                    View current;
                    Object next = it.next();
                    if (!(next instanceof View) || !(current = (View)next).getElement().equals(element)) continue;
                    alreadyShown = current;
                }
                if (alreadyShown != null) continue;
                RegionFigure targetFig = ((RegionEditPart)this.getHost().getParent()).getPrimaryShape();
                Rectangle targetFigBounds = targetFig.getBounds().getCopy();
                targetFig.translateToAbsolute((Translatable)targetFigBounds);
                Point mouseLocation = dropRequest.getLocation().getCopy();
                this.dropLocation = Zone.getZoneFromLocationInRectangleWithAbsoluteCoordinates(mouseLocation, targetFigBounds);
                if (Zone.isTop(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
                } else if (Zone.isLeft(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
                } else if (Zone.isRight(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
                    targetFigBounds.translate(targetFigBounds.width, 0);
                } else if (Zone.isBottom(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
                    targetFigBounds.translate(0, targetFigBounds.height);
                }
                this.getSizeOnDropFeedback().setBounds((Rectangle)new PrecisionRectangle(targetFigBounds));
            }
        }
    }
}

