/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.dialog;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.views.modelexplorer.LinkNode;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class NavigatorSearchDialog
extends TrayDialog {
    private ITreeContentProvider contentProvider = null;
    private ILabelProvider labelProvider = null;
    private Object root = null;
    private ISelectionProvider viewer = null;
    private List<Object> matchedObjects = Collections.emptyList();
    protected int currentIndex = 0;
    private Label matchesLabel;
    private StringEditor searchText;
    private Button backButton;
    private Button nextButton;
    private Button caseButton;

    @Deprecated
    public NavigatorSearchDialog(Shell shell, CommonNavigator modelNavigator) {
        super(shell);
        IContentProvider cprovider = modelNavigator.getCommonViewer().getContentProvider();
        if (cprovider instanceof ITreeContentProvider) {
            this.contentProvider = (ITreeContentProvider)cprovider;
        }
        this.root = modelNavigator.getCommonViewer().getInput();
        this.viewer = modelNavigator.getCommonViewer();
        this.labelProvider = (ILabelProvider)modelNavigator.getCommonViewer().getLabelProvider();
    }

    public NavigatorSearchDialog(Shell shell, TreeViewer viewer) {
        super(shell);
        this.viewer = viewer;
        try {
            this.labelProvider = (ILabelProvider)viewer.getLabelProvider();
            this.contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.root = viewer.getInput();
    }

    public NavigatorSearchDialog(Shell shell, Viewer viewer, ITreeContentProvider contentProvider, ILabelProvider labelProvider, Object root) {
        super(shell);
        this.viewer = viewer;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.root = root;
    }

    private void fireSetSelection(ISelection selection, boolean reveal) {
        if (this.viewer instanceof CommonViewer) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                ModelExplorerView.reveal(Iterables.transform((Iterable)Lists.newArrayList((Iterator)structured.iterator()), (Function)new Function<Object, EObject>(){

                    public EObject apply(Object arg0) {
                        return EMFHelper.getEObject((Object)arg0);
                    }
                }), (CommonViewer)this.viewer);
            }
        } else if (this.viewer instanceof Viewer) {
            Viewer view = (Viewer)this.viewer;
            view.setSelection(selection, true);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite background = new Composite(parent, 0);
        GridData bgData = new GridData(1808);
        bgData.minimumWidth = 300;
        background.setLayoutData((Object)bgData);
        GridLayout bgLayout = new GridLayout();
        bgLayout.numColumns = 2;
        background.setLayout((Layout)bgLayout);
        this.createSearchTextComposite(background);
        this.getShell().setText("Search");
        return background;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.backButton = this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
        this.nextButton = this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.nextButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NavigatorSearchDialog.this.currentIndex = NavigatorSearchDialog.this.currentIndex >= NavigatorSearchDialog.this.matchedObjects.size() - 1 ? 0 : ++NavigatorSearchDialog.this.currentIndex;
                NavigatorSearchDialog.this.fireSetSelection((ISelection)new StructuredSelection(NavigatorSearchDialog.this.matchedObjects.get(NavigatorSearchDialog.this.currentIndex)), true);
            }
        });
        this.backButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NavigatorSearchDialog.this.currentIndex = NavigatorSearchDialog.this.currentIndex <= 0 ? NavigatorSearchDialog.this.matchedObjects.size() - 1 : --NavigatorSearchDialog.this.currentIndex;
                NavigatorSearchDialog.this.fireSetSelection((ISelection)new StructuredSelection(NavigatorSearchDialog.this.matchedObjects.get(NavigatorSearchDialog.this.currentIndex)), true);
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    private void createSearchTextComposite(Composite background) {
        Label searchLabel = new Label(background, 0);
        searchLabel.setText("Search:");
        searchLabel.setLayoutData((Object)new GridData(128));
        this.searchText = new StringEditor(background, 128);
        this.searchText.setFocus();
        this.searchText.setLayoutData((Object)new GridData(768));
        this.searchText.addCommitListener(this.getCommitListener());
        this.searchText.setValidateOnDelay(true);
        this.caseButton = new Button(background, 32);
        this.caseButton.setText("Case sensitive?");
        GridData caseButtonData = new GridData(32);
        caseButtonData.horizontalSpan = 2;
        this.caseButton.setSelection(false);
        this.caseButton.setLayoutData((Object)caseButtonData);
        this.caseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NavigatorSearchDialog.this.updateMatches();
            }
        });
        Label resultsLabel = new Label(background, 0);
        resultsLabel.setText("Results:");
        resultsLabel.setLayoutData((Object)new GridData(128));
        this.matchesLabel = new Label(background, 0);
        this.matchesLabel.setText("No matchings.");
        this.matchesLabel.setLayoutData((Object)new GridData(800));
    }

    protected void clearMatches() {
        this.matchedObjects = Collections.emptyList();
        this.currentIndex = 0;
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.matchesLabel.setText("");
    }

    private void updateMatches() {
        if (this.contentProvider == null && this.labelProvider == null) {
            return;
        }
        String pattern = (String)this.searchText.getValue();
        if (pattern.length() == 0) {
            this.clearMatches();
            return;
        }
        if (!this.caseButton.getSelection()) {
            pattern = pattern.toUpperCase();
        }
        this.launchSearch(pattern, this.contentProvider.getElements(this.root));
        this.matchesLabel.setText(this.matchedObjects.size() + " matches found");
        if (!this.matchedObjects.isEmpty()) {
            this.fireSetSelection((ISelection)new StructuredSelection(this.matchedObjects.get(0)), true);
            this.nextButton.setEnabled(true);
            this.backButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
            this.backButton.setEnabled(false);
        }
    }

    protected void launchSearch(final String pattern, final Object[] root) {
        final boolean caseSensitive = this.caseButton.getSelection();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    NavigatorSearchDialog.this.matchedObjects = NavigatorSearchDialog.this.searchPattern(pattern, caseSensitive, Arrays.asList(root), monitor);
                    NavigatorSearchDialog.this.currentIndex = 0;
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private List<Object> searchPattern(String pattern, boolean caseSensitive, List<Object> objects, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<Object> matches = new ArrayList<Object>();
        ArrayList<Object> children = new ArrayList<Object>();
        for (Object o : objects) {
            String objectLabel;
            if (o instanceof Diagram) continue;
            String string = objectLabel = caseSensitive ? this.labelProvider.getText(o) : this.labelProvider.getText(o).toUpperCase();
            if (objectLabel.contains(pattern)) {
                matches.add(o);
            }
            EObject parentEObj = this.getAdapter(o, EObject.class);
            int i = 0;
            while (i < this.contentProvider.getChildren(o).length) {
                Object child = this.contentProvider.getChildren(o)[i];
                if (this.getAdapter(child, LinkNode.class) != null) {
                    Object[] objectArray = this.contentProvider.getChildren(child);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object referencedObject = objectArray[n2];
                        EObject referencedEObject = EMFHelper.getEObject((Object)referencedObject);
                        if (referencedEObject != null && (parentEObj == null || parentEObj.equals(referencedEObject.eContainer()))) {
                            children.add(referencedObject);
                        }
                        ++n2;
                    }
                } else {
                    EObject eObject = EMFHelper.getEObject((Object)child);
                    if (eObject != null && eObject.eContainer() != null && (parentEObj == null || eObject.eContainer().equals(parentEObj))) {
                        children.add(child);
                    }
                }
                ++i;
            }
        }
        if (!children.isEmpty()) {
            matches.addAll(this.searchPattern(pattern, caseSensitive, children, monitor));
        }
        return matches;
    }

    public <T> T getAdapter(Object object, Class<? extends T> toAdapt) {
        Object result = null;
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            result = adaptable.getAdapter(toAdapt);
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(object, toAdapt);
        }
        return (T)result;
    }

    protected ICommitListener getCommitListener() {
        return new ICommitListener(){
            private String lastValue = "";

            public void commit(AbstractEditor editor) {
                String newValue = (String)NavigatorSearchDialog.this.searchText.getValue();
                if (!this.lastValue.equals(newValue)) {
                    this.lastValue = newValue;
                    NavigatorSearchDialog.this.updateMatches();
                }
            }
        };
    }
}

