/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.service.types.internal.ui.Activator;
import org.eclipse.papyrus.uml.service.types.internal.ui.dialogs.AbstractAssociationSelectionDialog;
import org.eclipse.papyrus.uml.service.types.internal.ui.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Association;

public class AssociationSelectionDialog
extends AbstractAssociationSelectionDialog {
    private static final String UNTYPED = Messages.AssociationSelectionDialog_0;
    protected Association selectedAssociation;
    protected Set<Association> commonAssociations;
    private ServicesRegistry serviceRegistry;
    private boolean isCanceled = true;

    public AssociationSelectionDialog(Shell parent, int style, Set<Association> commonAssociations, ServicesRegistry serviceRegistry) {
        super(parent, style);
        this.commonAssociations = commonAssociations == null ? new HashSet() : commonAssociations;
        this.selectedAssociation = null;
        this.serviceRegistry = serviceRegistry;
    }

    private IBaseLabelProvider getLabelProvider() {
        try {
            return ((LabelProviderService)this.serviceRegistry.getService(LabelProviderService.class)).getLabelProvider();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    @Override
    protected void createContents() {
        super.createContents();
        IStructuredContentProvider associationContentProvider = new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList<String> result = new ArrayList<String>();
                result.add(UNTYPED);
                result.addAll(AssociationSelectionDialog.this.commonAssociations);
                return result.toArray();
            }
        };
        final TableViewer tableViewer = new TableViewer(this.table);
        tableViewer.setLabelProvider(this.getLabelProvider());
        tableViewer.setContentProvider((IContentProvider)associationContentProvider);
        tableViewer.setInput(this.commonAssociations);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AssociationSelectionDialog.this.btnOk.setEnabled(true);
            }
        });
        this.btnOk.setEnabled(false);
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ISelection selection = tableViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object selectedItem = ((IStructuredSelection)selection).getFirstElement();
                    AssociationSelectionDialog.this.selectedAssociation = selectedItem instanceof Association ? (Association)selectedItem : null;
                    AssociationSelectionDialog.this.isCanceled = false;
                    AssociationSelectionDialog.this.shlAssociationselection.close();
                }
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AssociationSelectionDialog.this.selectedAssociation = null;
                AssociationSelectionDialog.this.shlAssociationselection.close();
            }
        });
        this.btnCancel.setVisible(true);
    }

    public Association getSelectedAssociation() {
        return this.selectedAssociation;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

