/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.operations;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.GetRelTypesOnSourceOperation;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.GetRelTypesOnTargetOperation;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.GetTypesForPopupBarOperation;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.GetTypesForSourceOperation;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.GetTypesForTargetOperation;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.GetTypesOperation;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.IModelingAssistantOperation;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.emf.utils.ECollections2;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantPackage;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ConnectionAssistant;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ModelingAssistantProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.PopupAssistant;
import org.eclipse.papyrus.infra.gmfdiag.assistant.core.util.ModelingAssistantUtil;
import org.eclipse.papyrus.infra.gmfdiag.assistant.impl.ModelingAssistantProviderImpl;
import org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.util.ProviderCache;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;
import org.eclipse.uml2.common.util.CacheAdapter;

public class ModelingAssistantProviderOperations {
    private static final String ALL_TYPES = "all_types";

    protected ModelingAssistantProviderOperations() {
    }

    public static boolean provides(ModelingAssistantProvider modelingAssistantProvider, IOperation operation) {
        boolean result = false;
        switch (((IModelingAssistantOperation)operation).getId()) {
            case "GetRelTypesOnSource": 
            case "GetRelTypesOnTarget": 
            case "GetTypesForPopupBar": 
            case "GetRelTypesOnSourceAndTarget": 
            case "GetTypes": 
            case "GetTypesForSource": 
            case "GetTypesForTarget": {
                result = true;
            }
        }
        return result;
    }

    public static void addProviderChangeListener(ModelingAssistantProvider modelingAssistantProvider, IProviderChangeListener listener) {
        ((ModelingAssistantProviderImpl)modelingAssistantProvider).getListeners().add((Object)listener);
    }

    public static void removeProviderChangeListener(ModelingAssistantProvider modelingAssistantProvider, IProviderChangeListener listener) {
        ((ModelingAssistantProviderImpl)modelingAssistantProvider).getListeners().remove((Object)listener);
    }

    public static EList<IElementType> getTypes(ModelingAssistantProvider modelingAssistantProvider, String hint, IAdaptable data) {
        throw new UnsupportedOperationException();
    }

    public static EList<IElementType> getRelTypesOnSource(final ModelingAssistantProvider modelingAssistantProvider, IAdaptable source) {
        ProviderCache<IAdaptable, Object> cache = ProviderCache.getCache(modelingAssistantProvider, GetRelTypesOnSourceOperation.class);
        if (cache == null) {
            cache = ProviderCache.cache(modelingAssistantProvider, GetRelTypesOnSourceOperation.class, new Function<IAdaptable, EList<IElementType>>(){

                public EList<IElementType> apply(IAdaptable input) {
                    LinkedHashSet result = Sets.newLinkedHashSet();
                    for (ConnectionAssistant next : modelingAssistantProvider.getConnectionAssistants()) {
                        if (next.getSourceFilter() != null && !next.getSourceFilter().matches((Object)input)) continue;
                        ModelingAssistantProviderOperations.resolveAndAppendHintedTypes(next.getElementType(), modelingAssistantProvider, input, result);
                    }
                    result.remove(null);
                    return ModelingAssistantUtil.filterConnectionTypes(modelingAssistantProvider, result, input);
                }
            });
        }
        return (EList)cache.get(source);
    }

    public static EList<IElementType> getRelTypesOnTarget(final ModelingAssistantProvider modelingAssistantProvider, IAdaptable target) {
        ProviderCache<IAdaptable, Object> cache = ProviderCache.getCache(modelingAssistantProvider, GetRelTypesOnTargetOperation.class);
        if (cache == null) {
            cache = ProviderCache.cache(modelingAssistantProvider, GetRelTypesOnTargetOperation.class, new Function<IAdaptable, EList<IElementType>>(){

                public EList<IElementType> apply(IAdaptable input) {
                    LinkedHashSet result = Sets.newLinkedHashSet();
                    for (ConnectionAssistant next : modelingAssistantProvider.getConnectionAssistants()) {
                        if (next.getTargetFilter() != null && !next.getTargetFilter().matches((Object)input)) continue;
                        ModelingAssistantProviderOperations.resolveAndAppendHintedTypes(next.getElementType(), modelingAssistantProvider, input, result);
                    }
                    result.remove(null);
                    return ModelingAssistantUtil.filterConnectionTypes(modelingAssistantProvider, result, input);
                }
            });
        }
        return (EList)cache.get(target);
    }

    public static EList<IElementType> getRelTypesOnSourceAndTarget(ModelingAssistantProvider modelingAssistantProvider, IAdaptable source, IAdaptable target) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (ConnectionAssistant next : modelingAssistantProvider.getConnectionAssistants()) {
            if (next.getSourceFilter() != null && !next.getSourceFilter().matches((Object)source) || next.getTargetFilter() != null && !next.getTargetFilter().matches((Object)target)) continue;
            ModelingAssistantProviderOperations.resolveAndAppendHintedTypes(next.getElementType(), modelingAssistantProvider, source, result);
        }
        result.remove(null);
        return ModelingAssistantUtil.filterConnectionTypes(modelingAssistantProvider, result, source);
    }

    public static EList<IElementType> getRelTypesForSREOnTarget(ModelingAssistantProvider modelingAssistantProvider, IAdaptable target) {
        throw new UnsupportedOperationException();
    }

    public static EList<IElementType> getRelTypesForSREOnSource(ModelingAssistantProvider modelingAssistantProvider, IAdaptable source) {
        throw new UnsupportedOperationException();
    }

    public static EList<IElementType> getTypesForSource(ModelingAssistantProvider modelingAssistantProvider, IAdaptable target, IElementType relationshipType) {
        ProviderCache<IAdaptable, Object> cache = ProviderCache.getCache(modelingAssistantProvider, GetTypesForSourceOperation.class);
        if (cache == null) {
            cache = ProviderCache.cache(modelingAssistantProvider, GetTypesForSourceOperation.class, new Function<IAdaptable, Map<IElementType, EList<IElementType>>>(){

                public Map<IElementType, EList<IElementType>> apply(IAdaptable input) {
                    return new HashMap<IElementType, EList<IElementType>>();
                }
            });
        }
        IElementType semanticRelationship = ModelingAssistantUtil.resolveSemanticType(relationshipType);
        Map relationShipToTypes = (Map)cache.get(target);
        return relationShipToTypes.computeIfAbsent(semanticRelationship, src -> {
            LinkedHashSet types = Sets.newLinkedHashSet();
            ImmutableList validTypes = ImmutableList.copyOf((Iterable)Iterables.filter(modelingAssistantProvider.getElementTypes(), ModelingAssistantUtil.notSpecializationOfAny(modelingAssistantProvider.getExcludedElementTypes())));
            for (ConnectionAssistant next : modelingAssistantProvider.getConnectionAssistants()) {
                if (!ModelingAssistantUtil.isSubtype(relationshipType, next.getElementType()) || next.getTargetFilter() != null && !next.getTargetFilter().matches((Object)target)) continue;
                for (IElementType sourceType : validTypes) {
                    if (next.getSourceFilter() != null && !next.getSourceFilter().matches((Object)sourceType) || modelingAssistantProvider.isRelationshipType(sourceType)) continue;
                    ModelingAssistantUtil.collectAllConcreteSubtypes(sourceType, modelingAssistantProvider, types);
                }
            }
            ECollections2.ImmutableEListBuilder result = ECollections2.immutableEListBuilder();
            for (IElementType next : types) {
                ModelingAssistantProviderOperations.resolveAndAppendHintedTypes(next, modelingAssistantProvider, target, (ECollections2.ImmutableEListBuilder<? super IElementType>)result);
            }
            return result.sort(ModelingAssistantUtil.alphabetical()).build();
        });
    }

    public static EList<IElementType> getTypesForTarget(ModelingAssistantProvider modelingAssistantProvider, IAdaptable source, IElementType relationshipType) {
        ProviderCache<IAdaptable, Object> cache = ProviderCache.getCache(modelingAssistantProvider, GetTypesForTargetOperation.class);
        if (cache == null) {
            cache = ProviderCache.cache(modelingAssistantProvider, GetTypesForTargetOperation.class, new Function<IAdaptable, Map<IElementType, EList<IElementType>>>(){

                public Map<IElementType, EList<IElementType>> apply(IAdaptable input) {
                    return new HashMap<IElementType, EList<IElementType>>();
                }
            });
        }
        IElementType semanticRelationship = ModelingAssistantUtil.resolveSemanticType(relationshipType);
        Map relationShipToTypes = (Map)cache.get(source);
        return relationShipToTypes.computeIfAbsent(semanticRelationship, src -> {
            LinkedHashSet types = Sets.newLinkedHashSet();
            ImmutableList validTypes = ImmutableList.copyOf((Iterable)Iterables.filter(modelingAssistantProvider.getElementTypes(), ModelingAssistantUtil.notSpecializationOfAny(modelingAssistantProvider.getExcludedElementTypes())));
            for (ConnectionAssistant next : modelingAssistantProvider.getConnectionAssistants()) {
                if (!ModelingAssistantUtil.isSubtype(relationshipType, next.getElementType()) || next.getSourceFilter() != null && !next.getSourceFilter().matches((Object)source)) continue;
                for (IElementType targetType : validTypes) {
                    if (next.getTargetFilter() != null && !next.getTargetFilter().matches((Object)targetType) || modelingAssistantProvider.isRelationshipType(targetType)) continue;
                    ModelingAssistantUtil.collectAllConcreteSubtypes(targetType, modelingAssistantProvider, types);
                }
            }
            ECollections2.ImmutableEListBuilder result = ECollections2.immutableEListBuilder();
            for (IElementType next : types) {
                ModelingAssistantProviderOperations.resolveAndAppendHintedTypes(next, modelingAssistantProvider, source, (ECollections2.ImmutableEListBuilder<? super IElementType>)result);
            }
            EList build = result.sort(ModelingAssistantUtil.alphabetical()).build();
            return build;
        });
    }

    public static EObject selectExistingElementForSource(ModelingAssistantProvider modelingAssistantProvider, IAdaptable target, IElementType relationshipType) {
        throw new UnsupportedOperationException();
    }

    public static EObject selectExistingElementForTarget(ModelingAssistantProvider modelingAssistantProvider, IAdaptable source, IElementType relationshipType) {
        throw new UnsupportedOperationException();
    }

    public static EList<IElementType> getTypesForPopupBar(final ModelingAssistantProvider modelingAssistantProvider, IAdaptable host) {
        ProviderCache<IAdaptable, Object> cache = ProviderCache.getCache(modelingAssistantProvider, GetTypesForPopupBarOperation.class);
        if (cache == null) {
            cache = ProviderCache.cache(modelingAssistantProvider, GetTypesForPopupBarOperation.class, new Function<IAdaptable, EList<IElementType>>(){

                public EList<IElementType> apply(IAdaptable input) {
                    LinkedHashSet types = Sets.newLinkedHashSet();
                    for (PopupAssistant next : modelingAssistantProvider.getPopupAssistants()) {
                        if (next.getFilter() != null && !next.getFilter().matches((Object)input)) continue;
                        ModelingAssistantProviderOperations.resolveAndAppendHintedTypes(next.getElementType(), modelingAssistantProvider, input, types);
                    }
                    types.remove(null);
                    ECollections2.ImmutableEListBuilder result = ECollections2.immutableEListBuilder();
                    result.addAll((Iterable)types);
                    return result.sort(ModelingAssistantUtil.alphabetical()).build();
                }
            });
        }
        return (EList)cache.get(host);
    }

    protected static void resolveAndAppendHintedTypes(IElementType typeToResolve, ModelingAssistantProvider provider, IAdaptable context, Collection<? super IElementType> resolvedTypes) {
        if (typeToResolve != null) {
            if (ModelingAssistantProviderOperations.hasVisualID(typeToResolve) || !ModelingAssistantProviderOperations.isDiagramContext(context)) {
                resolvedTypes.add((IElementType)typeToResolve);
            } else {
                resolvedTypes.addAll(ModelingAssistantUtil.getHintedTypes(typeToResolve, provider, context));
            }
        }
    }

    protected static boolean isDiagramContext(IAdaptable context) {
        return AdapterUtils.adapt((Object)context, View.class).isPresent();
    }

    protected static boolean hasVisualID(IElementType type) {
        if (!(type instanceof IHintedType)) {
            return false;
        }
        String hint = ((IHintedType)type).getSemanticHint();
        return hint != null && !hint.isEmpty();
    }

    protected static void resolveAndAppendHintedTypes(IElementType typeToResolve, ModelingAssistantProvider provider, IAdaptable context, ECollections2.ImmutableEListBuilder<? super IElementType> resolvedTypes) {
        if (ModelingAssistantProviderOperations.hasVisualID(typeToResolve) || !ModelingAssistantProviderOperations.isDiagramContext(context)) {
            resolvedTypes.add((Object)typeToResolve);
        } else {
            resolvedTypes.addAll(ModelingAssistantUtil.getHintedTypes(typeToResolve, provider, context));
        }
    }

    public static EList<IElementType> getElementTypes(final ModelingAssistantProvider modelingAssistantProvider) {
        ProviderCache<String, Object> cache = ProviderCache.getCache(modelingAssistantProvider, GetTypesOperation.class);
        if (cache == null) {
            cache = ProviderCache.cache(modelingAssistantProvider, GetTypesOperation.class, new Function<String, EList<IElementType>>(){

                public EList<IElementType> apply(String input) {
                    LinkedHashSet types = Sets.newLinkedHashSet();
                    for (String next : modelingAssistantProvider.getElementTypeIDs()) {
                        IElementType type = modelingAssistantProvider.getElementType(next);
                        if (type == null) continue;
                        types.add(type);
                    }
                    ECollections2.ImmutableEListBuilder result = ECollections2.immutableEListBuilder();
                    result.addAll((Iterable)types);
                    return result.sort(ModelingAssistantUtil.alphabetical()).build();
                }
            });
        }
        return (EList)cache.get(ALL_TYPES);
    }

    public static IClientContext getClientContext(ModelingAssistantProvider modelingAssistantProvider) {
        IClientContext result = null;
        if (modelingAssistantProvider.getClientContextID() != null) {
            result = ClientContextManager.getInstance().getClientContext(modelingAssistantProvider.getClientContextID());
        }
        if (result == null && (result = ElementTypeUtils.getDefaultClientContext()) == null) {
            result = ClientContextManager.getDefaultClientContext();
        }
        return result;
    }

    public static IElementType getElementType(ModelingAssistantProvider modelingAssistantProvider, String id) {
        IMetamodelType next;
        IMetamodelType result = null;
        IMetamodelType[] iMetamodelTypeArray = ElementTypeRegistry.getInstance().getMetamodelTypes(modelingAssistantProvider.getClientContext());
        int n = iMetamodelTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            next = iMetamodelTypeArray[n2];
            if (Objects.equal((Object)next.getId(), (Object)id)) {
                result = next;
                break;
            }
            ++n2;
        }
        if (result == null) {
            iMetamodelTypeArray = ElementTypeRegistry.getInstance().getSpecializationTypes(modelingAssistantProvider.getClientContext());
            n = iMetamodelTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                next = iMetamodelTypeArray[n2];
                if (Objects.equal((Object)next.getId(), (Object)id)) {
                    result = next;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static EList<IElementType> getExcludedElementTypes(ModelingAssistantProvider modelingAssistantProvider) {
        LinkedHashSet types = Sets.newLinkedHashSet();
        for (String next : modelingAssistantProvider.getExcludedElementTypeIDs()) {
            IElementType type = modelingAssistantProvider.getElementType(next);
            if (type == null) continue;
            types.add(type);
        }
        ECollections2.ImmutableEListBuilder result = ECollections2.immutableEListBuilder();
        result.addAll((Iterable)types);
        return result.sort(ModelingAssistantUtil.alphabetical()).build();
    }

    public static EList<IElementType> getRelationshipTypes(ModelingAssistantProvider modelingAssistantProvider) {
        LinkedHashSet types = Sets.newLinkedHashSet();
        for (String next : modelingAssistantProvider.getRelationshipTypeIDs()) {
            IElementType type = modelingAssistantProvider.getElementType(next);
            if (type == null) continue;
            types.add(type);
        }
        ECollections2.ImmutableEListBuilder result = ECollections2.immutableEListBuilder();
        result.addAll((Iterable)types);
        return result.sort(ModelingAssistantUtil.alphabetical()).build();
    }

    public static boolean isRelationshipType(ModelingAssistantProvider modelingAssistantProvider, IElementType elementType) {
        Object relationshipTypes;
        CacheAdapter cache = CacheAdapter.getCacheAdapter((Notifier)modelingAssistantProvider);
        if (cache == null) {
            relationshipTypes = ImmutableSet.copyOf(modelingAssistantProvider.getRelationshipTypes());
        } else {
            relationshipTypes = (Set)cache.get(modelingAssistantProvider.eResource(), (EObject)modelingAssistantProvider, (Object)AssistantPackage.Literals.MODELING_ASSISTANT_PROVIDER___IS_RELATIONSHIP_TYPE__IELEMENTTYPE);
            if (relationshipTypes == null) {
                relationshipTypes = ImmutableSet.copyOf(modelingAssistantProvider.getRelationshipTypes());
                cache.put(modelingAssistantProvider.eResource(), (EObject)modelingAssistantProvider, (Object)AssistantPackage.Literals.MODELING_ASSISTANT_PROVIDER___IS_RELATIONSHIP_TYPE__IELEMENTTYPE, relationshipTypes);
            }
        }
        boolean result = relationshipTypes.contains(elementType);
        if (!result) {
            IElementType[] allSupers = elementType.getAllSuperTypes();
            int i = allSupers.length - 1;
            while (!result && i >= 0) {
                result = relationshipTypes.contains(allSupers[i]);
                --i;
            }
        }
        return result;
    }
}

