/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractGraphicalParametricAction;

public class ArrangeAction
extends AbstractGraphicalParametricAction {
    public static final String ARRANGE_ALL = "arrangeAll";
    public static final String ARRANGE_SELECTION = "arrangeSelection";

    public ArrangeAction(String parameter, List<IGraphicalEditPart> selection) {
        super(parameter, selection);
    }

    @Override
    protected Command getBuildedCommand() {
        CompoundCommand command = new CompoundCommand("Arrange Command");
        if (this.getParameter().equals(ARRANGE_ALL)) {
            ArrangeRequest request = new ArrangeRequest("arrangeAllAction");
            request.setPartsToArrange(this.createOperationSetForArrangeAll(this.getSelection()));
            for (EditPart editPart : this.getSelection()) {
                Command cmd = editPart.getCommand((Request)request);
                if (cmd == null || !cmd.canExecute()) continue;
                command.add(cmd);
            }
        } else if (this.getParameter().equals(ARRANGE_SELECTION)) {
            Command command2;
            ArrangeRequest request = new ArrangeRequest("arrangeSelectionAction");
            request.setPartsToArrange(this.getSelection());
            EditPart commonAncestor = this.getTargetEditPartForArrangeSelection(this.getSelection(), (Request)request);
            if (commonAncestor != null && (command2 = commonAncestor.getCommand((Request)request)) != null) {
                command.add(command2);
            }
        }
        return command.isEmpty() ? null : command;
    }

    private EditPart getTargetEditPartForArrangeSelection(List<?> editparts, Request request) {
        if (editparts.size() == 1) {
            return ((EditPart)editparts.get(0)).getTargetEditPart(request);
        }
        EditPart parentEP = this.getSelectionParent(editparts);
        if (parentEP == null) {
            return null;
        }
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (!(part instanceof ConnectionEditPart) && part.getParent() != parentEP) {
                return null;
            }
            ++i;
        }
        return parentEP;
    }

    @Override
    public boolean isEnabled() {
        if (this.getParameter().equals(ARRANGE_ALL)) {
            return true;
        }
        return super.isEnabled();
    }

    protected EditPart getSelectionParent(List<?> editparts) {
        ListIterator<?> li = editparts.listIterator();
        while (li.hasNext()) {
            Object obj = li.next();
            if (obj instanceof ConnectionEditPart || !(obj instanceof EditPart)) continue;
            return ((EditPart)obj).getParent();
        }
        return null;
    }

    protected List<IGraphicalEditPart> createOperationSetForArrangeAll(List<IGraphicalEditPart> selection) {
        HashSet<IGraphicalEditPart> parentsSet = new HashSet<IGraphicalEditPart>();
        for (IGraphicalEditPart element : selection) {
            EditPart gEditPart;
            EditPart parentEditPart;
            if (element instanceof ShapeCompartmentEditPart || element instanceof DiagramEditPart) {
                parentsSet.add(element);
                continue;
            }
            if (!(element instanceof EditPart) || !((parentEditPart = (gEditPart = (EditPart)element).getParent()) instanceof ShapeCompartmentEditPart) && !(parentEditPart instanceof DiagramEditPart) || parentsSet.contains(parentEditPart)) continue;
            parentsSet.add((IGraphicalEditPart)parentEditPart);
        }
        if (parentsSet.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IGraphicalEditPart> elements = new ArrayList<IGraphicalEditPart>();
        elements.addAll(parentsSet);
        return elements;
    }

    @Override
    protected List<IGraphicalEditPart> getSelection() {
        List<IGraphicalEditPart> selection = super.getSelection();
        if (ARRANGE_ALL.equals(this.getParameter())) {
            if (!selection.isEmpty()) {
                return this.createOperationSetForArrangeAll(selection);
            }
            if (this.getDiagramEditPart() != null) {
                return this.getDiagramEditPart().getChildren();
            }
            return Collections.EMPTY_LIST;
        }
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        selection = ToolUtilities.getSelectionWithoutDependants(selection).stream().filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast).toList();
        return selection;
    }
}

