/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.composite;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.emf.facet.util.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.composite.IFilteredElementSelectionComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class FilteredElementSelectionComposite
extends Composite
implements IFilteredElementSelectionComposite {
    private final Text filterText;
    private final FilteredList fFilteredList;
    private String matchPrefix;

    public FilteredElementSelectionComposite(Composite parent, final boolean matchAnywhere, boolean multiSelection) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout());
        this.filterText = FilteredElementSelectionComposite.createFilterText(this);
        this.fFilteredList = FilteredElementSelectionComposite.createFilteredList(this, multiSelection);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                FilteredElementSelectionComposite.this.getfFilteredList().setFilter(FilteredElementSelectionComposite.this.getMatchPrefix(matchAnywhere) + FilteredElementSelectionComposite.this.getFilterText().getText());
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x1000002) {
                    FilteredElementSelectionComposite.this.getfFilteredList().setFocus();
                }
            }

            public void keyReleased(KeyEvent event) {
            }
        });
    }

    protected String getMatchPrefix(boolean matchAnywhere) {
        this.matchPrefix = matchAnywhere ? "*" : "";
        return this.matchPrefix;
    }

    @Override
    public void setElements(Object[] elements) {
        this.fFilteredList.setElements(elements);
    }

    protected static FilteredList createFilteredList(Composite parent, boolean multiSelection) {
        int multi = multiSelection ? 2 : 4;
        FilteredList filteredList = new FilteredList(parent, 0xB00 | multi, (ILabelProvider)new LabelProvider(), true, false, true);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        filteredList.setLayoutData((Object)data);
        filteredList.setFilter("");
        return filteredList;
    }

    protected static Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setMessage(Messages.FilteredElementSelectionControl_type_filter_text);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        return text;
    }

    @Override
    public Object getFirstSelectedElement() {
        Object result = null;
        Object[] selection = this.fFilteredList.getSelection();
        if (selection.length > 0) {
            result = selection[0];
        }
        return result;
    }

    @Override
    public Object[] getSelectedElements() {
        Object[] result = null;
        if (this.fFilteredList.getSelection().length > 0) {
            result = this.fFilteredList.getSelection();
        }
        return result;
    }

    @Override
    public FilteredList getFilteredList() {
        return this.fFilteredList;
    }

    @Override
    public Text getFilterText() {
        return this.filterText;
    }

    protected FilteredList getfFilteredList() {
        return this.fFilteredList;
    }
}

